//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.6/classes/tests/TestDnsLabelSequence.cc 9953 $
// @(#) $Id: TestDnsLabelSequence.cc 9953 2018-01-10 01:00:12Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDnsLAbelSequence.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <ctype.h>
}

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmDnsLabelSequence.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.6/classes/tests/TestDnsLabelSequence.cc 9953 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void PrintPacket(const uint8_t *pkt, const uint8_t *endptr)
{
  for (const uint8_t *p = pkt; p < endptr; ++p) {
    if (isprint(*p)) {
      cout << (char)(*p);
    }
    else {
      if (*p == 0xc0) {
        cout << " [" << (uint16_t)*(++p) << "] ";
      }
      else {
        cout << ' ' << (uint16_t)(*p) << ' ';
      }
    }
  }
  cout << '\n' << "len: " << (endptr - pkt) << '\n';
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void TestDomainNames()
{
  const vector<string>  domainNames = {
    "ria.rfdm.com",
    "kiva.rfdm.com",
    "rfdm.com",
    "pi1.rfdm.com",
    "www.rfdm.com",
    "hackintosh.rfdm.com"
  };
  uint8_t               pkt[4096] = { 0 };
  uint8_t              *ptr = pkt;
  Dns::LabelPositions   lps;
  
  for (auto dn : domainNames) {
    Dns::LabelSequence  dls(dn);
    ptr = dls.Encode(pkt, ptr, 4096, lps);
  }

  const uint8_t  *rptr = pkt;
  for (int i = 0; i < domainNames.size(); ++i) {
    Dns::LabelSequence  dls;
    rptr = dls.Decode(pkt, rptr, 4096);
    UnitAssert((string)dls == domainNames[i]);
  }
#if 0
  PrintPacket(pkt, rptr);
#endif
  //  Test that we get exception when trying to decode from a too-short
  //  packet.
  int  numExceptions = 0;
  rptr = pkt;
  for (int i = 0; i < domainNames.size(); ++i) {
    Dns::LabelSequence  dls;
    try {
      rptr = dls.Decode(pkt, rptr, 1);
      UnitAssert("exception not thrown!" == 0);
    }
    catch (...) {
      ++numExceptions;
    }
  }
  UnitAssert(numExceptions == domainNames.size());
  
  //  Test that we get exception when trying to encode into a too-short
  //  packet.
  numExceptions = 0;
  ptr = pkt;
  for (auto dn : domainNames) {
    Dns::LabelSequence  dls(dn);
    try {
      ptr = dls.Encode(pkt, ptr, 1, lps);
      UnitAssert("exception not thrown!" == 0);
    }
    catch (...) {
      ++numExceptions;
    }
  }
  UnitAssert(numExceptions == domainNames.size());
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestDomainNames();
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
    return 1;
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
    return 0;
  }
}
