//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.7/classes/tests/TestDnsMessage.cc 10029 $
// @(#) $Id: TestDnsMessage.cc 10029 2018-01-17 06:44:47Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDnsMessage.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
}

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmDnsMessage.hh"
#include "DwmDnsRRDataA.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.7/classes/tests/TestDnsMessage.cc 10029 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestQueryEncodeDecode()
{
  Dns::Message  message;
  message.Header().RecursionDesired(true);
  Dns::MessageQuestion  question("mcplex.net", Dns::MessageQuestion::k_typeA,
                                 Dns::MessageQuestion::k_classIN);
  message.Questions().push_back(question);

  uint8_t   pkt[512];
  uint8_t  *ptr = pkt;
  message.Encode(pkt, ptr, 512);

  Dns::Message    rmessage;
  const uint8_t  *rptr = pkt;
  rmessage.Decode(pkt, rptr, 512);
  UnitAssert(message == rmessage);
  UnitAssert(rptr == ptr);

  message.Clear();
  message.Header().RecursionDesired(true);
  question.QName("www.mcplex.net");
  question.QType(Dns::MessageQuestion::k_typeAAAA);
  question.QClass(Dns::MessageQuestion::k_classIN);
  message.Questions().push_back(question);
  ptr = pkt;
  message.Encode(pkt, ptr, 512);

  rptr = pkt;
  rmessage.Decode(pkt, rptr, 512);
  UnitAssert(message == rmessage);
  UnitAssert(rptr == ptr);
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestAnswerEncodeDecode()
{
  Dns::Message  message;
  message.Header().RecursionDesired(true);
  Dns::MessageQuestion  question("www.mcplex.net",
                                 Dns::MessageQuestion::k_typeA,
                                 Dns::MessageQuestion::k_classIN);
  message.Questions().push_back(question);
  Dns::ResourceRecord  answer;
  answer.Name("www.mcplex.net");
  answer.TTL(3600);
  in_addr  a;
  inet_pton(AF_INET, "192.168.168.2", &a);
  answer.Data(Dns::RRDataA(a));
  message.Answers().push_back(answer);

  uint8_t   pkt[512] = { 0 };
  uint8_t  *ptr = pkt;
  message.Encode(pkt, ptr, 512);

  Dns::Message    rmessage;
  const uint8_t  *rptr = pkt;
  rmessage.Decode(pkt, rptr, 512);
  UnitAssert(message == rmessage);
  UnitAssert(rmessage.Header().QuestionCount() == 1);
  UnitAssert(rmessage.Questions().size() == 1);
  UnitAssert(rmessage.Header().AnswerCount() == 1);
  UnitAssert(rmessage.Answers().size() == 1);
  UnitAssert(rptr == ptr);

  message.Clear();
  question.QName("www.mcplex.net");
  question.QType(Dns::MessageQuestion::k_typeAAAA);
  question.QClass(Dns::MessageQuestion::k_classIN);
  message.Questions().push_back(question);
  answer.Name("www.mcplex.net");
  answer.TTL(3600);
  in6_addr  a6;
  inet_pton(AF_INET6, "fd60:3019:f4a1:caaf::2", &a6);
  answer.Data(Dns::RRDataAAAA(a6));
  message.Answers().push_back(answer);
  ptr = pkt;
  message.Encode(pkt, ptr, 512);
  rptr = pkt;
  rmessage.Decode(pkt, rptr, 512);
  UnitAssert(message == rmessage);
  UnitAssert(rmessage.Header().QuestionCount() == 1);
  UnitAssert(rmessage.Questions().size() == 1);
  UnitAssert(rmessage.Header().AnswerCount() == 1);
  UnitAssert(rmessage.Answers().size() == 1);
  UnitAssert(rptr == ptr);
  message.Clear();
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestQueryEncodeDecode();
  TestAnswerEncodeDecode();
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
    return 1;
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
    return 0;
  }
}
