//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.7/classes/tests/TestDnsMessageHeader.cc 9995 $
// @(#) $Id: TestDnsMessageHeader.cc 9995 2018-01-13 01:57:10Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDnsMessageHeader.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmDnsMessageHeader.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.7/classes/tests/TestDnsMessageHeader.cc 9995 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
void TestEncodeDecode()
{
  uint8_t   pkt[4096] = { 0 };
  
  Dns::MessageHeader  hdrs[4], rhdrs[4];
  for (uint16_t id = 0; id < 65535; ++id) {
    hdrs[id % 4].Id(id);
    hdrs[id % 4].IsResponse((id % 2) ? true : false);
    hdrs[id % 4].OpCode(id % 16);
    if (! hdrs[id % 4].IsResponse()) {
      hdrs[id % 4].IsAuthoritativeAnswer(false);
      hdrs[id % 4].IsTruncated(false);
      hdrs[id % 4].RecursionDesired((id % 2) ? false : true);
      hdrs[id % 4].RecursionAvailable(false);
      hdrs[id % 4].ResponseCode(0);
      hdrs[id % 4].QuestionCount(1);
      hdrs[id % 4].AnswerCount(0);
      hdrs[id % 4].AuthorityCount(0);
      hdrs[id % 4].AdditionalCount(id % 2);
    }
    else {
      hdrs[id % 4].IsAuthoritativeAnswer((id % 2) ? false : true);
      hdrs[id % 4].IsTruncated((id % 2) ? true : false);
      hdrs[id % 4].RecursionDesired(false);
      hdrs[id % 4].RecursionAvailable((id % 2) ? false : true);
      hdrs[id % 4].ResponseCode(id % 16);
      hdrs[id % 4].QuestionCount(1);
      hdrs[id % 4].AnswerCount(id % 8);
      hdrs[id % 4].AuthorityCount((id % 5) + 1);
      hdrs[id % 4].AdditionalCount(id % 2);
    }
    if (id && ((id % 4) == 0)) {
      uint8_t  *ptr = pkt;
      ptr = hdrs[0].Encode(pkt, ptr, 4096);
      ptr = hdrs[1].Encode(pkt, ptr, 4096);
      ptr = hdrs[2].Encode(pkt, ptr, 4096);
      ptr = hdrs[3].Encode(pkt, ptr, 4096);
      const uint8_t  *rptr = pkt;
      rptr = rhdrs[0].Decode(pkt, rptr, 4096);
      rptr = rhdrs[1].Decode(pkt, rptr, 4096);
      rptr = rhdrs[2].Decode(pkt, rptr, 4096);
      rptr = rhdrs[3].Decode(pkt, rptr, 4096);
      UnitAssert(rhdrs[0] == hdrs[0]);
      UnitAssert(rhdrs[1] == hdrs[1]);
      UnitAssert(rhdrs[2] == hdrs[2]);
      UnitAssert(rhdrs[3] == hdrs[3]);
      UnitAssert(rptr == ptr);
    }
  }
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestEncodeDecode();

  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
    return 1;
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
    return 0;
  }
  
}

