#!/bin/sh

# The rules of thumb, when dealing with these values are:
#
#     - Always increase the revision value.
#     - Increase the current value whenever an interface has been added,
#       removed or changed.
#     - Increase the age value only if the changes made to the ABI are
#       backward compatible.
#
# Format is "current:revision:age"
SHARED_LIB_VERSION="2:1:0"

IsTrunk() {
    echo $1 | egrep '\/trunk\/' > /dev/null
    if [ $? -eq 0 ]; then
	echo 0
    fi
}

IsTag() {
    echo $1 | egrep '\/tags\/' > /dev/null
    if [ $? -eq 0 ]; then
	echo 0
    fi
}

IsBranch() {
    echo $1 | egrep '\/branches\/' > /dev/null
    if [ $? -eq 0 ]; then
	echo 0
    fi
}

GetTagVersion() {
    local ver=`echo "$1" | sed -e 's/.*\/tags\/\([^/]*\)\/.*/\1/'`
    echo "${ver}"
}

GetTrunkVersion() {
    local dir=`echo "$1" | sed -e 's/.*\/\([^/]*\)\/trunk\/.*/\1/'`
    echo "${dir}-0.0.`svnversion . | sed 's/[0-9]*://g'`"
}

GetBranchVersion() {
    local dir=`echo "$1" | sed -e 's/.*\/branches\/\([^/]*\)\/.*/\1/'`
    echo "${dir}-0.0.`svnversion . | sed 's/[0-9]*://g'`"
}

GetVersion() {
    if [ $(IsTag "$1") ]; then
	echo $(GetTagVersion "$1")
    else
	if [ $(IsBranch "$1") ]; then
	    echo $(GetBranchVersion "$1")
	else
	    if [ $(IsTrunk "$1") ]; then    
		echo $(GetTrunkVersion "$1")
	    fi
	fi
    fi
}

args=`getopt sv $*`
set -- $args
ver=$(GetVersion "$DwmPath: dwm/DwmDns/tags/DwmDns-0.2.7/getvers.sh 11523 $")
for i; do
    case "$i" in
	-s)
	    echo ${SHARED_LIB_VERSION}
	    exit 0
	    ;;
	-v)
	    echo ${ver} | cut -d'-' -f2-
	    exit 0
	    break;;
    esac
done
echo $(GetVersion "$DwmPath: dwm/DwmDns/tags/DwmDns-0.2.7/getvers.sh 11523 $")
