//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmPfRule.hh 9415 2017-06-03 23:04:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmPfRule.hh
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMPFRULE_HH_
#define _DWMPFRULE_HH_

extern "C" {
  #include <sys/types.h>
  #include <sys/socketvar.h>
  #include <net/if.h>
#ifndef __APPLE__
  #include <net/pfvar.h>
#else
  #include "macos_net_pfvar.h"
#endif
  #include <netinet/in.h>
  #include <netinet/in_pcb.h>

#ifdef __APPLE__
  struct in_endpoints {
    u_int16_t       ie_fport;               /* foreign port */
    u_int16_t       ie_lport;               /* local port */
    /* protocol dependent part, local and foreign addr */
    union {
      /* foreign host table entry */
      struct  in_addr_4in6 ie46_foreign;
      struct  in6_addr ie6_foreign;
    } ie_dependfaddr;
    union {
      /* local host table entry */
      struct  in_addr_4in6 ie46_local;
      struct  in6_addr ie6_local;
    } ie_dependladdr;
    u_int32_t       ie6_zoneid;             /* scope zone id */
  };
  #define ie_faddr        ie_dependfaddr.ie46_foreign.ia46_addr4
  #define ie_laddr        ie_dependladdr.ie46_local.ia46_addr4
  #define ie6_faddr       ie_dependfaddr.ie6_foreign
  #define ie6_laddr       ie_dependladdr.ie6_local
#endif
}

#include <set>

#include "DwmIpv4Prefix.hh"

namespace Dwm {

  namespace Pf {

    class Device;
    
    //------------------------------------------------------------------------
    //!  This class encapsulates a pf rule  EXPERIMENTAL SINCE pf_rule
    //!  CONTAINS POINTERS WHOSE VALIDITY MAY BE TEMPORAL!!!
    //------------------------------------------------------------------------
    class Rule
    {
    public:
      Rule(const Device & dev, pfioc_rule & pfr, int ruleNum);
      Rule(const Device & dev, pf_rule & pr, int ruleNum);
      bool MatchesInbound(const struct in_endpoints & endpoints) const;

      std::set<Ipv4Prefix> DestinationPrefixes() const;
      std::set<uint16_t> DestinationPorts() const;
      std::set<Ipv4Prefix> SourcePrefixes() const;
      std::set<uint16_t> SourcePorts() const;
      
    private:
      const Device  &_dev;
      int            _ruleNum;
      pf_rule        _rule;

      static bool PortMatches(uint8_t op, uint16_t a1, uint16_t a2,
                              uint16_t p);
    };
    
        
  }  // namespace Pf

}  // namespace Dwm

#endif  // _DWMPFRULE_HH_
