//===========================================================================
// @(#) $Name:$
// @(#) $Id: TestRules.cc 9415 2017-06-03 23:04:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestRules.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
}

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmPfDevice.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmPf/tags/libDwmPf-0.1.3/tests/TestRules.cc 9415 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  struct in_endpoints  endPoints = {
    .ie_fport = htons(53371),
    .ie_lport = htons(443),
    .ie_faddr = inet_addr("115.28.1.1"),
    .ie_laddr = inet_addr("68.51.190.242")
  };
    
  Pf::Device  dev("/dev/pf");
  if (UnitAssert(dev.Open())) {
#ifndef __APPLE__
    vector<Pf::Rule>  rules = dev.GetRulesWithTable(argv[1]);
    UnitAssert(! rules.empty());
    for (const auto & rule : rules) {
      if (rule.MatchesInbound(endPoints)) {
        cerr << "Found inbound match\n";
      }
#if 0      
      set<Ipv4Prefix>  &&spfxs = rule.SourcePrefixes();
      if (! spfxs.empty()) {
        cout << "source prefixes:\n";
        for (const auto & pfx : spfxs) {
          cout << "  " << pfx.ToShortString() << '\n';
        }
      }
      set<Ipv4Prefix>  &&dpfxs = rule.DestinationPrefixes();
      if (! dpfxs.empty()) {
        cout << "destination prefixes:\n";
        for (const auto & pfx : dpfxs) {
          cout << "  " << pfx.ToShortString() << '\n';
        }
      }
#endif
    }
#endif  // __APPLE__
    dev.Close();
  }

  if (Assertions::Total().Failed() > 0) {
    Assertions::Print(cerr, true);
    return(1);
  }
  else {
    cout << Dwm::Assertions::Total() << " passed\n";
  }
  return 0;
}

  
