//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPServer.hh 9002 2017-04-10 06:39:25Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPServer.hh
//!  \brief Dwm::RDAP::Server class definition
//---------------------------------------------------------------------------

#ifndef _DWMRDAPSERVER_HH_
#define _DWMRDAPSERVER_HH_

#include <chrono>
#include <thread>
#include <vector>

#include "DwmSocket.hh"
#include "DwmIpv4CountryDb.hh"
#include "DwmRDAPResponder.hh"
#include "DwmRDAPServerConfig.hh"

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  Encapsulates my RDAP-lite server.  This is just the listener part,
    //!  each client will get its own Responder.  This class also holds the
    //!  database.
    //------------------------------------------------------------------------
    class Server
    {
    public:
      //----------------------------------------------------------------------
      //!  Construct from a path to my RSA private key file, an
      //!  authorized_keys file and a server configuration object.
      //----------------------------------------------------------------------
      Server(const std::string & myPrivKeyPath,
             const std::string & authorizedKeysPath,
             const ServerConfig & config);

      //----------------------------------------------------------------------
      //!  Start the server.
      //----------------------------------------------------------------------
      bool Start();
      
      //----------------------------------------------------------------------
      //!  Stop the server.
      //----------------------------------------------------------------------
      void Stop();

    private:
      std::string               _myPrivKeyPath;
      std::string               _authorizedKeysPath;
      const ServerConfig       &_config;
      Ipv4CountryDb             _db;
      CountryCodes              _cc;
      Socket                    _socket;
      Socket                    _mcastSocket;
      bool                      _run;
      std::thread               _thread;
      std::vector<Responder *>  _responders;
      std::chrono::system_clock::time_point  _nextKeygenTime;

      void StopResponders();
      void CleanupResponders();
      void Run();
      void GenerateNewKeys();
    };
    
  }  // namespace RDAP

}  // namespace Dwm

#endif  // _DWMRDAPSERVER_HH_
