//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPQuerySessions.hh 9185 2017-04-20 00:09:29Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPQuerySessions.hh
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMRDAPQUERYSESSIONS_HH_
#define _DWMRDAPQUERYSESSIONS_HH_

#include <map>
#include <string>
#include <vector>

#include <Poco/Net/HTTPClientSession.h>
#include <Poco/Net/SSLManager.h>

#include "DwmRDAPQuery.hh"
#include "DwmRDAPResponse.hh"

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class QuerySessions
    {
    public:
      QuerySessions();
      ~QuerySessions();
      
      Poco::Net::HTTPClientSession *GetSession(const Query & query);

      RDAP::IPv4Response Execute(const Query & query);
      
    private:
      std::map<std::string, Poco::Net::HTTPClientSession *>  _sessions;
      Poco::Net::Context::Ptr                                _context;

      static void FindVcardArrays(const Json::Value & jv,
                                  std::vector<Json::Value> & vcardArrays);
      static std::string FindCountryInVcard(const Json::Value & jv);
    };
    
  }  // namespace RDAP

}  // namespace Dwm

#endif  // _DWMRDAPQUERYSESSIONS_HH_
