//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmCountryCode.cc 8904 2017-03-27 06:23:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmCountryCode.cc
//!  \brief Dwm::CountryCode class implementation
//---------------------------------------------------------------------------

#include <cassert>

#include "DwmIO.hh"
#include "DwmSvnTag.hh"
#include "DwmCountryCode.hh"

using namespace std;

namespace Dwm {

  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  CountryCode::CountryCode(const Json::Value & jv)
      : _data()
  {
    if (jv["a2"].isString() && (jv["a2"].asString().length() == 2)) {
      if (jv["a3"].isString() && (jv["a3"].asString().length() == 3)) {
        if (jv["name"].isString() && (! jv["name"].asString().empty())) {
          Alpha2(jv["a2"].asString());
          Alpha3(jv["a3"].asString());
          Name(jv["name"].asString());
        }
      }
    }
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  Json::Value CountryCode::Json() const
  {
    Json::Value  jv;
    if ((Alpha2().length() == 2)
        && (Alpha3().length() == 3)
        && (! Name().empty())) {
      jv["a2"] = Alpha2();
      jv["a3"] = Alpha3();
      jv["name"] = Name();
    }
    return jv;
  }

  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  const std::string & CountryCode::Alpha2() const
  {
    return get<0>(_data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  const std::string & CountryCode::Alpha2(const std::string & alpha2)
  {
    assert(alpha2.length() == 2);
    get<0>(_data) = alpha2;
    return get<0>(_data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  const std::string & CountryCode::Alpha3() const
  {
    return get<1>(_data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  const std::string & CountryCode::Alpha3(const std::string & alpha3)
  {
    assert(alpha3.length() == 3);
    get<1>(_data) = alpha3;
    return get<1>(_data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  const std::string & CountryCode::Name() const
  {
    return get<2>(_data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  const std::string & CountryCode::Name(const std::string & name)
  {
    get<2>(_data) = name;
    return get<2>(_data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  std::istream & CountryCode::Read(std::istream & is)
  {
    return IO::Read(is, _data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  ssize_t CountryCode::Read(int fd)
  {
    return IO::Read(fd, _data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  size_t CountryCode::Read(FILE *f)
  {
    return IO::Read(f, _data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  std::ostream & CountryCode::Write(std::ostream & os) const
  {
    return IO::Write(os, _data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  ssize_t CountryCode::Write(int fd) const
  {
    return IO::Write(fd, _data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  size_t CountryCode::Write(FILE *f) const
  {
    return IO::Write(f, _data);
  }
  
  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  uint32_t CountryCode::StreamedLength() const
  {
    return IO::StreamedLength(_data);
  }
  
  
  
}  // namespace Dwm
