//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPResponse.cc 8926 2017-03-29 05:40:25Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPResponse.cc
//!  \brief Dwm::RDAP::Response class implementation
//---------------------------------------------------------------------------

#include "DwmIpv4Prefix.hh"
#include "DwmSvnTag.hh"
#include "DwmRDAPResponse.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmRDAP/tags/libDwmRDAP-0.2.1/src/DwmRDAPResponse.cc 8926 $");

using namespace std;

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    DateTime IPv4Response::LastChanged() const
    {
      DateTime  dt = DateTime(TimeValue64(0,0));
      DateTime  tmpdt(false);
  
      if (this->isMember("events")) {
        if ((*this)["events"].isArray()) {
          for (int e = 0; e < (*this)["events"].size(); ++e) {
            if ((*this)["events"][e].isMember("eventAction")
                && (*this)["events"][e].isMember("eventDate")
                && ((*this)["events"][e]["eventAction"].asString()
                    == "last changed")) {
              if (tmpdt.Parse((*this)["events"][e]["eventDate"].asString(),
                              "%Y-%m-%dT%H:%M:%S")) {
                if (dt < tmpdt) {
                  dt = tmpdt;
                }
              }
            }
          }
        }
      }
      return dt;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    pair<Ipv4Address,Ipv4Address> IPv4Response::AddressRange() const
    {
      pair<Ipv4Address,Ipv4Address>  rc(INADDR_ANY, INADDR_ANY);
      
      const Json::Value  & jv = *this;
      if (jv.isMember("startAddress")) {
        if (jv["startAddress"].isString()
            && (! jv["startAddress"].asString().empty())) {
          if (jv.isMember("endAddress")) {
            if (jv["endAddress"].isString()
                && (! jv["endAddress"].asString().empty())) {
              Ipv4Prefix  startpfx(jv["startAddress"].asString());
              Ipv4Prefix  endpfx(jv["endAddress"].asString());
              rc.first = startpfx.FirstAddress();
              rc.second = endpfx.LastAddress();
            }
          }
        }
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    vector<Ipv4Prefix> IPv4Response::Prefixes() const
    {
      vector<Ipv4Prefix>  rc;
      pair<Ipv4Address,Ipv4Address> &&addrs = AddressRange();
      if ((addrs.first != INADDR_ANY) && (addrs.second != INADDR_ANY)) {
        rc = Ipv4RangePrefixes(addrs.first, addrs.second);
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string IPv4Response::Country() const
    {
      string  rc;
      const Json::Value  & jv = *this;
      if (jv.isMember("country")
          && jv["country"].isString()) {
        string  s = jv["country"].asString();
        if (s.length() == 2) {
          for (auto & c : s) { c = toupper(c); }
          rc = s;
        }
      }
      return rc;
    }
    
    
  }  // namespace RDAP

}  // namespace Dwm
