//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPServer.cc 12106 2022-12-04 06:18:56Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPServer.cc
//!  \brief Dwm::RDAP::Server class implementation
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
#ifndef __APPLE__
  #ifndef __linux__
    #include <pthread_np.h>
  #else
    #include <pthread.h>
  #endif
#endif
}

#include <sstream>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmTimeValue64.hh"
#include "libDwmRDAPPortability.hh"
#include "DwmRDAPServer.hh"

static const Dwm::SvnTag  svntag("@(#) $DwmPath: dwm/libDwmRDAP/tags/libDwmRDAP-0.3.3/apps/dwmrdapd/DwmRDAPServer.cc 12106 $");

using namespace std;

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Server::Stop()
    {
      for (auto & a : _acceptors) {
        a.cancel();
      }
      Syslog(LOG_INFO, "Server stopped");
      return;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Server::CleanupResponders()
    {
      for (auto ri = _responders.begin(); ri != _responders.end(); ) {
        if ((*ri)->Join()) {
          ri = _responders.erase(ri++);
        }
        else {
          ++ri;
        }
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Server::AcceptLoop(boost::asio::ip::tcp::acceptor & a)
    {
      using boost::asio::ip::tcp;
      
      a.async_accept(a.get_executor(),
                     [this,&a](error_code ec, tcp::socket && s)
                     {
                       CleanupResponders();
                       if (! ec) {
                         _responders.push_back(std::make_shared<Responder>(std::move(s), *this, _cc));
                         AcceptLoop(a);
                       }
                       else {
                         Syslog(LOG_ERR, "Exiting AcceptLoop()");
                       }
                     });
    }

  }  // namespace RDAP

}  // namespace Dwm
