//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmRDAPQuerySessions.cc 12078 2022-11-26 03:33:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmRDAPQuerySessions.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <regex>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmWebUtils.hh"
#include "DwmWebUtilsUrl.hh"
#include "DwmRDAPQuerySessions.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmRDAP/tags/libDwmRDAP-0.3.4/src/DwmRDAPQuerySessions.cc 12078 $");

using namespace std;

namespace Dwm {

  namespace RDAP {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QuerySessions::QuerySessions()
    {
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QuerySessions::~QuerySessions()
    {
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void QuerySessions::FindVcardArrays(const nlohmann::json & jv,
                                        vector<nlohmann::json> & vcardArrays)
    {
      if (jv.is_object()) {
        if ((jv.find("vcardArray") != jv.end())
            && jv["vcardArray"].is_array()) {
          vcardArrays.push_back(jv["vcardArray"]);
        }
        for (auto & el : jv.items()) {
          if (el.key() != "vcardArray") {
            FindVcardArrays(jv[el.key()], vcardArrays);
          }
        }
      }
      else if (jv.is_array()) {
        for (int i = 0; i < jv.size(); ++i) {
          if (jv[i].is_object() && (jv[i].find("vcardArray") != jv[i].end())
              && jv[i]["vcardArray"].is_array()) {
            vcardArrays.push_back(jv[i]["vcardArray"]);
          }
          FindVcardArrays(jv[i], vcardArrays);
        }
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string QuerySessions::FindCountryInVcard(const nlohmann::json & jv)
    {
      static const map<string,string>  ccodeMap = {
        { "ANGUILLA",                             "AI" },
        { "ANTARCTICA",                           "AQ" },
        { "ANTIGUA AND BARBUDA",                  "AG" },
        { "BAHAMAS",                              "BS" },
        { "BARBADOS",                             "BB" },
        { "BERMUDA",                              "BM" },
        { "BOUVET ISLAND",                        "BV" },
        { "CANADA",                               "CA" },
        { "CAYMAN ISLANDS",                       "KY" },
        { "DOMINICA",                             "DM" },
        { "GRENADA",                              "GD" },
        { "GUADELOUPE",                           "GP" },
        { "HEARD AND MC DONALD ISLANDS",          "HM" },
        { "JAMAICA",                              "JM" },
        { "MARTINIQUE",                           "MQ" },
        { "MONTSERRAT",                           "MS" },
        { "PUERTO RICO",                          "PR" },
        { "SAINT BARTHELEMY",                     "BL" },
        { "SAINT KITTS AND NEVIS",                "KN" },
        { "SAINT LUCIA",                          "LC" },
        { "SAINT VINCENT AND THE GRENADINES",     "VC" },
        { "ST. PIERRE AND MIQUELON",              "PM" },
        { "ST. HELENA",                           "SH" },
        { "ST. MARTIN",                           "MF" },
        { "TURKS AND CAICOS ISLANDS",             "TC" },
        { "UNITED STATES",                        "US" },
        { "UNITED STATES MINOR OUTLYING ISLANDS", "UM" },
        { "VIRGIN ISLANDS (BRITISH)",             "VG" },
        { "VIRGIN ISLANDS (U.S.)",                "VI" }
      };
      
      vector<nlohmann::json>  vcardArrays;
      FindVcardArrays(jv, vcardArrays);
      for (auto vca : vcardArrays) {
        for (int vi = 0; vi < vca.size(); ++vi) {
          const nlohmann::json &  vc = vca[vi];
          if (vc.is_array()) {
            for (int vci = 0; vci < vc.size(); ++vci) {
              if (vc[vci].is_array()) {
                const nlohmann::json & vcm = vc[vci];
                for (int vcmi = 0; vcmi < vcm.size(); ++vcmi) {
                  if (vcm[vcmi].is_object()) {
                    if ((vcm[vcmi].find("label") != vcm[vcmi].end())
                        && vcm[vcmi]["label"].is_string()) {
                      string  label = vcm[vcmi]["label"].get<string>();
                      string::size_type  idx = label.find_last_of('\n');
                      if ((idx != string::npos) && (idx < (label.size() - 1))) {
                        auto  cc = ccodeMap.find(label.substr(idx+1));
                        if (cc != ccodeMap.end()) {
                          if (cc->second != "US") {
                            return cc->second;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      return string("US");
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RDAP::IPv4Response QuerySessions::Execute(const Query & query)
    {
      RDAP::IPv4Response  rc;
      if (WebUtils::GetJson(query.Uri(), rc)) {
        Query::FixIpv4Stupidity(rc["startAddress"]);
        Query::FixIpv4Stupidity(rc["endAddress"]);
        WebUtils::Url  url(query.Uri());
        if (url.Host().find_last_of("arin.net") != string::npos) {
          if ((rc.find("country") == rc.end())
              || (rc["country"].is_string()
                  && rc["country"].get<string>().empty())) {
            //  Fudge for more ARIN stupidity
            string  &&vcardCcode = FindCountryInVcard(rc);
            if (! vcardCcode.empty()) {
              rc["country"] = vcardCcode;
            }
            else {
              rc["country"] = "US";
            }
          }
        }
      }
      return rc;
    }
    
  }  // namespace RDAP

}  // namespace Dwm
