//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcBlockLogRegexMatcher.hh 9221 2017-04-24 13:42:29Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcBlockLogRegexMatcher.hh
//!  \brief Dwm::McBlock::LogRegexMatcher class definition
//---------------------------------------------------------------------------

#ifndef _DWMMCBLOCKLOGREGEXMATCHER_HH_
#define _DWMMCBLOCKLOGREGEXMATCHER_HH_

#include <regex>
#include <string>
#include <vector>

#include "DwmIpv4Address.hh"

namespace Dwm {

  namespace McBlock {

    //------------------------------------------------------------------------
    //!  Encapsulates a vector of regular expressions loaded from a file.
    //!  With correctly formed regular expressions that capture an IPv4
    //!  address, this can be used to match log file entries from sshd,
    //!  httpd, etc.
    //------------------------------------------------------------------------
    class LogRegexMatcher
    {
    public:
      //----------------------------------------------------------------------
      //!  Load the regular expressions from the given @c file.
      //----------------------------------------------------------------------
      LogRegexMatcher(const std::string & regexFile);
      
      //----------------------------------------------------------------------
      //!  If @c line matches one of the contained regular expressions,
      //!  the first mamber of the return value will be true and the
      //!  second member will contain the matching IP address.
      //----------------------------------------------------------------------
      std::pair<bool,Ipv4Address> Matches(const std::string & line);

    private:
      std::vector<std::regex>  _regexes;
    };
    
  }  // namespace McBlock

}  // namespace Dwm

#endif  // _DWMMCBLOCKLOGREGEXMATCHER_HH_
