//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmMcBlockResponseMessage.cc 12091 2022-11-29 05:05:27Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcBlockResponseMessage.cc
//!  \brief Dwm::McBlock::ResponseMassage class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcBlockResponseMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcblock/tags/mcblock-0.3.6/classes/src/DwmMcBlockResponseMessage.cc 12091 $");

using namespace std;

namespace Dwm {

  namespace McBlock {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ResponseMessage::ResponseMessage()
        : _value()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ResponseMessage::ResponseMessage(const nlohmann::json & value)
        : _value(value)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ResponseMessage::ResponseMessage(nlohmann::json && value)
        : _value(std::move(value))
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const nlohmann::json & ResponseMessage::Json() const
    {
      return _value;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const nlohmann::json & ResponseMessage::Json(const nlohmann::json & value)
    {
      _value = value;
      return _value;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ResponseMessage::Read(Credence::Peer & peer)
    {
      bool  rc = false;
      _value.clear();
      _value = "";
      std::string  s;
      if (peer.Receive(s)) {
        _value = nlohmann::json::parse(s, nullptr, false);
        if (! _value.is_discarded()) {
          rc = true;
        }
        else {
          Syslog(LOG_ERR, "Failed to parse response message");
        }
      }
      else {
        Syslog(LOG_ERR, "Failed to read response message");
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool ResponseMessage::Write(Credence::Peer & peer) const
    {
      bool  rc = false;
      std::string  s = _value.dump();
      if (peer.Send(s)) {
        rc = true;
      }
      else {
        Syslog(LOG_ERR, "Failed to write response message");
      }
      return rc;
    }
    
    
  }  // namespace McBlock

}  // namespace Dwm
