//===========================================================================
// @(#) $Name$
// @(#) $Id: TestDwmMcBlockDbEntry.cc 1135 2015-08-12 05:20:25Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2015
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDwmBlockDbEntry.hh
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <sstream>

#include "DwmSysLogger.hh"
#include "DwmUnitAssert.hh"
#include "DwmMcBlockDbEntry.hh"

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestIOStream()
{
  string  s;
  ostringstream  os(s);

  McBlock::DbEntry  dbe1;
  dbe1.Prefix(Ipv4Prefix("10.1.1/24"));
  dbe1.Registry("ARIN");
  dbe1.Country("China");
  UnitAssert(dbe1.Write(os));
  UnitAssert(os.tellp() == dbe1.StreamedLength());

  {
    istringstream  is(os.str());
    McBlock::DbEntry  dbe2;
    UnitAssert(dbe2.Read(is));
    UnitAssert(is.tellg() == dbe1.StreamedLength());
    UnitAssert(dbe1 == dbe2);
  }
  
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  SysLogger::Open("TestDwmBgp4Aggregator", LOG_PERROR|LOG_NDELAY, LOG_USER);
  SysLogger::ShowPriorities(true);
  SysLogger::ShowFileLocation(true);

  TestIOStream();

  if (Dwm::Assertions::Total().Failed() > 0) {
    Dwm::Assertions::Print(std::cerr, true);
    return 1;
  }
  else {
    std::cout << Dwm::Assertions::Total() << " passed" << std::endl;
  }

  return 0;
}
