//===========================================================================
// @(#) $Name:$
// @(#) $Id: TestDwmMcBlockResponseMessage.cc 12110 2022-12-05 01:39:07Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDwmMcBlockResponseMessage.cc
//!  \brief Dwm::McBlock::ResponseMessage unit tests
//---------------------------------------------------------------------------

extern "C" {
  #include <fcntl.h>
  #include <unistd.h>
}

#include "DwmOptArgs.hh"
#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmMcBlockResponseMessage.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcblock/tags/mcblock-0.3.6/classes/tests/TestDwmMcBlockResponseMessage.cc 12110 $");

using namespace std;
using namespace Dwm;
using McBlock::ResponseMessage;

static bool  g_printJson;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestDescriptorIO()
{
  nlohmann::json  prefixes;
  prefixes[0] = "10.11.12/24";
  prefixes[1] = "10.12.13/24";
  prefixes[2] = "10.13.14/24";

  nlohmann::json  val1, val2, val3, val4;
  val1["prefix"] = "10.11.12/24";
  val2["prefix"] = "10.12.13/24";
  val3["prefixes"] = prefixes;
  val4["active"] = false;
  
  vector<ResponseMessage>  messages = {
    ResponseMessage(val1),
    ResponseMessage(val2),
    ResponseMessage(val3),
    ResponseMessage(val4)
  };

  UnitAssert(messages[2].Json()["prefixes"].is_array());
  for (int i = 0; i < prefixes.size(); ++i) {
    UnitAssert(messages[2].Json()["prefixes"][i].is_string());
    UnitAssert(messages[2].Json()["prefixes"][i].get<string>()
               == prefixes[i].get<string>());
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  int  rc;
  
  Dwm::OptArgs  optargs;
  optargs.AddOptArg("p", "print", false, "false", "print JSON messages");
  optargs.Parse(argc, argv);
  g_printJson = optargs.Get<bool>('p');

  TestDescriptorIO();

  if (Assertions::Total().Failed()) {
    Assertions::Print(std::cerr, true);
    rc = 1;
  }
  else {
    std::cout << Assertions::Total() << " passed" << std::endl;
    rc = 0;
  }

  return rc;
}
