//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/mcrover/DwmMcroverBeastie1.cc 10997 $
// @(#) $Id: DwmMcroverBeastie1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverBeastie1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>
#include <curses.h>

#include "DwmMcroverBeastie1.hh"
#include "DwmMcroverColorPairs.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string>  g_beastie1 = {
      R"(             ,        ,)",
      R"(            /(        )`)",
      R"(            \ \___   / |)",
      R"(            /- _  `-/  ')",
      R"(           (/\/ \ \   /\)",
      R"(           / /   | `    \)",
      R"(           O O   ) /    |)",
      R"(           `-^--'`<     ')",
      R"(          (_.)  _  )   /)",
      R"(           `.___/`    /)",
      R"(             `-----' /)",
      R"(<----.     __ / __   \)",
      R"(<----|====O)))==) \) /====|)",
      R"(<----'    `--' `.__,' \)",
      R"(             |        |)",
      R"(              \       /       /\)",
      R"(         ______( (__ / \______/)",
      R"(       ,'  ,-----'   |)",
      R"(       `--{__________))"
    };

    static const vector<string>  g_beastiemask1 = {
      R"(             r        r)",
      R"(            rr        rr)",
      R"(            r rrrr   r r)",
      R"(            rr w  rrr  r)",
      R"(           rwww w r   rr)",
      R"(           w w   w r    r)",
      R"(           b b   w r    r)",
      R"(           wwwwwwwr     r)",
      R"(          rrrr  w  r   r)",
      R"(           rrwwwww    r)",
      R"(             rrrrrrr r)",
      R"(yyyyyy     rr r rr   r)",
      R"(yyyyyyyyyyyrrryyr rr ryyyyy)",
      R"(yyyyyy    rrrr rrrrrr r)",
      R"(             r        r)",
      R"(              r       r       rr)",
      R"(         wgggggr rgg r rrrrrrrr)",
      R"(       ww  wwggggg   g)",
      R"(       wwwwwwggggggggg)"
    };
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Beastie1::Width() const
    {
      return max_element(g_beastie1.begin(), g_beastie1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Beastie1::Height() const
    {
      return g_beastie1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Beastie1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        if (COLORS < 16) {
          wattrset(win, COLOR_PAIR(ColorPairs::Pair("red"))|A_BOLD);
        }
        else {
          wattrset(win, COLOR_PAIR(ColorPairs::Pair("brightred"))|A_BOLD);
        }
        for (int ln = 0; ln < g_beastie1.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_beastie1[ln].c_str());
          wclrtoeol(win);
        }

        int  white = ColorPairs::Pair("white");
        int  green = ColorPairs::Pair("green");
        int  red, skyblue, yellow;
        if (COLORS < 16) {
          red = ColorPairs::Pair("red");
          skyblue = ColorPairs::Pair("cyan");
          yellow = ColorPairs::Pair("yellow");
        }
        else {
          red = ColorPairs::Pair("brightred");
          skyblue = ColorPairs::Pair("skyblue");
          yellow = ColorPairs::Pair("brightyellow");
        }

        std::unordered_map<char,int>  colors = {
          { 'b', skyblue },
          { 'g', green },
          { 'r', red },
          { 'w', white },
          { 'y', yellow }
        };
          
        for (int ln = 0; ln < g_beastiemask1.size(); ++ln) {
          for (int c = 0; c < g_beastiemask1[ln].size(); ++c) {
            if (' ' != g_beastiemask1[ln][c]) {
              auto  it = colors.find(g_beastiemask1[ln][c]);
              if (it != colors.end()) {
                mvwchgat(win, origy+ln, origx+c, 1, A_NORMAL,
                         it->second, nullptr);
              }
            }
          }
        }
        mvwchgat(win, origy+19,    origx, -1, A_NORMAL, white, nullptr);
      }
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
