//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/mcrover/DwmMcroverDilbert1.cc 10997 $
// @(#) $Id: DwmMcroverDilbert1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverDilbert1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>
#include <unordered_map>

#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverDilbert1.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    static const vector<string>  g_dilbert1 = {
      R"(                          .s*"*s+.)",
      R"(                          $;    `*b. .ss.)",
      R"(                          `Ts.    `TP' `T..ss.)",
      R"(                            `*b         $P  `T_,+.)",
      R"(                             d'              :P'`$.)",
      R"(                            d'                   :Ts.)",
      R"(                           d'                   '  `*Ts.)",
      R"(                          d'                          `$;)",
      R"(                         d'                       .bs+sP)",
      R"(                        d'                        $)",
      R"(                       d'                        :;)",
      R"(                 s**s.d'                         $)",
      R"(                d'.s $+_    .+s*s.              :;)",
      R"(               d'dP d' `*+,d*'   `b             $)",
      R"(              d'dP d'     d'     .P.s*s.       :;)",
      R"(              T.  d'      $     .Pd'   `b      $)",
      R"(               `*d'       T.   .Pd'     $     :;)",
      R"(                d'         `*sP' $     .P     $)",
      R"(               d'         .+     T.   .P"*+. :;_)",
      R"(              d'         d'      `*sP'     `^$P*s.)",
      R"(             d'         :$        :         :; s`T)",
      R"(            d'          :$        $         $ :P.P)",
      R"(           d'            `Ts._  _.P        :;:P.P)",
      R"(_        .d;               `"*TsP'         $;'.P)",
      R"(^Ts._   d'`Tb.                            :;TsP)",
      R"( :P"*Tsd;   `*Tb.                         $)",
      R"(.P     Ts.     `*Tb.                     :;)",
      R"(P       `Ts.      `*Tb.                  $)",
      R"(          `Ts.       `$Tb._             :;)",
      R"(b           `Ts.    .d$$$$$$$g+._       $)",
      R"($b            `Ts..dP'T$$$$$  `"*^Tbs+sd;)",
      R"($P*.            `TP'b  `T$$$           :b)",
      R"(P   $.             d$.  JTd$          _.sP+.)",
      R"(     $$._         d$$$sP*' $bss++ssdP*'  `*Ts._)",
      R"(     $$$$Ts._  _.d$$$$$b                     `*Tbs.)",
      R"(     $$$$$$$$T^*' `T$$$P                         `*b)",
      R"(     :$$$$$$$       T$P                            $)",
      R"(     :$$$$$$$       :P                             $)",
      R"(      $$$$$$$b     .P                              $)"
    };

    static const vector<string>  g_dilbertmask1 = {
      R"(                          ffffffff)",
      R"(                          ff    ffff ffff)",
      R"(                          ffff    ffff fffffff)",
      R"(                            fff         ff  ffffff)",
      R"(                             ff              ffffff)",
      R"(                            ff                   ffff)",
      R"(                           ff                   f  fffff)",
      R"(                          ff                          fff)",
      R"(                         ff                       ffffff)",
      R"(                        ff                        f)",
      R"(                       ff                        ff)",
      R"(                 fffffff                         f)",
      R"(                ffff ggg    gggggg              ff)",
      R"(               ffff ff ggggggg   gg             f)",
      R"(              ffff ff     gg     ggggggg       ff)",
      R"(              ff  ff      g     gggg   gg      f)",
      R"(               ffff       gg   gggg     g     ff)",
      R"(                ff         ggggg g     gg     f)",
      R"(               ff         ff     gg   gggggg fff)",
      R"(              ff         ff      ggggg     gggffff)",
      R"(             ff         ff        f         ff fff)",
      R"(            ff          ff        f         f ffff)",
      R"(           ff            fffff  fff        ffffff)",
      R"(s        sss               fffffff         fffff)",
      R"(sssss   ssssss                            fffff)",
      R"( ttssssss   sssss                         f)",
      R"(tt     sss     sssss                     ff)",
      R"(t       ssss      sssss                  f)",
      R"(          ssss       ssssss             ff)",
      R"(t           ssss    sstttttssssss       f)",
      R"(tt            ssssssssttttts  sssssssssss)",
      R"(tttt            sssst  tttts           ss)",
      R"(t   tt             ttt  ttts          ssssss)",
      R"(     tttt         tttttttt ssssssssssss  ssssss)",
      R"(     tttttttt  ttttttttt                     ssssss)",
      R"(     tttttttttttt tttttt                         sss)",
      R"(     tttttttt       ttt                            s)",
      R"(     tttttttt       tt                             s)",
      R"(      tttttttt     tt                              s)"
    };
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Dilbert1::Width() const
    {
      return max_element(g_dilbert1.begin(), g_dilbert1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Dilbert1::Height() const
    {
      return g_dilbert1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Dilbert1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        for (int ln = 0; ln < g_dilbert1.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_dilbert1[ln].c_str());
          wclrtoeol(win);
        }
        int  cyan   = ColorPairs::Pair("cyan");
        int  wheat1 = ColorPairs::Pair("wheat1");
        int  red    = ColorPairs::Pair("brightred");
        int  white  = ColorPairs::Pair("white");
        
        if (COLORS < 16) {
          wheat1 = ColorPairs::Pair("yellow");
          red = ColorPairs::Pair("red");
        }

        std::unordered_map<char,int>  cm = {
          { 'f', wheat1 },  //  'flesh'
          { 'g', cyan },    //  'glasses'
          { 's', white },   //  'shirt'
          { 't', red }      //  'tie'
        };
        
        for (int ln = 0; ln < g_dilbertmask1.size(); ++ln) {
          for (int c = 0; c < g_dilbertmask1[ln].size(); ++c) {
            if (' ' != g_dilbertmask1[ln][c]) {
              auto  it = cm.find(g_dilbertmask1[ln][c]);
              if (it != cm.end()) {
                mvwchgat(win, origy+ln, origx+c, 1, A_NORMAL, it->second,
                         nullptr);
              }
            }
          }
        }
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::pair<int,int> Dilbert1::Position(WINDOW *win) const
    {
      std::pair<int,int>  rc(0,0);
      if (win) {
        int  h, w;
        getmaxyx(win, h, w);
        if (h > (Height() + 1)) {
          rc.first = h - Height();
        }
        rc.second = 1;
      }
      return rc;
    }
    
          
  }  // namespace Mcrover

}  // namespace Dwm
