//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/mcrover/DwmMcroverKermit1.cc 10997 $
// @(#) $Id: DwmMcroverKermit1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverKermit1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <curses.h>
#include <vector>

#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverKermit1.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string> g_kermit1 = {
      R"(                     #########)",
      R"(                 ################  ########)",
      R"(               ####################++++++++#####)",
      R"(              ######        ########++++++++++++##########)",
      R"(             ######       ###########++++++++################)",
      R"(            #####       ############++++++++###################)",
      R"(            ####  ################+++++++++++######    #########)",
      R"(           #####################++++++++++++++#######      ######)",
      R"(           #################+++++++++++++++++++#######     #######)",
      R"(         ##+#############+++++++++++++++++++++++######     #######)",      
      R"(        #++++++####++++++++++++++++++++++++++++++########   ######)",
      R"(      ##++++++++++++++++++++++++++++++++++++++++++########  ######)",
      R"(    ##++++++++++++++++++++++++++++++++++++++++++++++##############)",
      R"(   #++++++++++++++++++++++++++++++++++++++++++++++++++##########++#)",
      R"(  #++++++++++++++++++++++++++++++++++++++++++++++++++++++######++++#)",
      R"( #++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"( #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"(#++++++#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"(#++++##+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"(#+++##+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"(#+++#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++##+++++#)",
      R"( #+++#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#++++#)",
      R"( #+++#+++###+++++++++++++++++++++++++++++++++++++++++++++++++++++++#++++#)",
      R"(  #+++#++#XX###++++++++++++++++++++++++++++++++++++++++++++++++++++#++++#)",
      R"(   #++++++##xx####++++++++++++++++++++++++++++++++++++++####++++++##+++#)",
      R"(    #+++++++#xxxxx#####+++++++++++++++++++++++++++######XX#++++++##+++#)",
      R"(     #+++++++#xxxxxxxxx########++++++++++#########xxxxxx##++++++++++##)",
      R"(      ##++++++#xxxxxxxxxxxxxxxx##########xxxxxxxxxxxxx##+++++++++++#)",
      R"(        #++++++##xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx###+++++++++++##)",
      R"(         #+++++++#xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(          #+++++++#xxxxxxxxxxxxxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(           #+++++++##xxxxxxxxxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(            ##+++++++#xxxxxxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(              ##++++++##xxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(                ##++++++##xxxxxxxxxxxxx##++++++++++++##)",
      R"(                  ##++++++###xxxxxxx###++++++++++++##)",
      R"(                    ##+++++++#######+++++++++++++##)",
      R"(                      ##+++++++++++++++++++++++##)",
      R"(                        ##+++++++++++++++++++##)",
      R"(                          ##+++++++++++++####)",
      R"(                            #############)"
    };

    static const vector<string> g_kermitmask1 = {
      R"(                     wwwwwwwww)",
      R"(                 wwwwwwwwwwwwwwww  ########)",
      R"(               wwwwwwwwwwwwwwwwwwww++++++++#####)",
      R"(              wwwwww        wwwwwwww++++++++++++wwwwwwwwww)",
      R"(             wwwwww       wwwwwwwwwww++++++++wwwwwwwwwwwwwwww)",
      R"(            wwwww       wwwwwwwwwwww++++++++wwwwwwwwwwwwwwwwwww)",
      R"(            wwww  wwwwwwwwwwwwwwww+++++++++++wwwwww    wwwwwwwww)",
      R"(           wwwwwwwwwwwwwwwwwwwww++++++++++++++wwwwwww      wwwwww)",
      R"(           wwwwwwwwwwwwwwwww+++++++++++++++++++wwwwwww     wwwwwww)",
      R"(         ##+wwwwwwwwwwwww+++++++++++++++++++++++wwwwww     wwwwwww)",      
      R"(        #++++++wwww++++++++++++++++++++++++++++++wwwwwwww   wwwwww)",
      R"(      ##++++++++++++++++++++++++++++++++++++++++++wwwwwwww  wwwwww)",
      R"(    ##++++++++++++++++++++++++++++++++++++++++++++++wwwwwwwwwwwwww)",
      R"(   #++++++++++++++++++++++++++++++++++++++++++++++++++wwwwwwwwww++#)",
      R"(  #++++++++++++++++++++++++++++++++++++++++++++++++++++++wwwwww++++#)",
      R"( #++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"( #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"(#++++++#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"(#++++##+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"(#+++##+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#)",
      R"(#+++#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++##+++++#)",
      R"( #+++#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#++++#)",
      R"( #+++#+++###+++++++++++++++++++++++++++++++++++++++++++++++++++++++#++++#)",
      R"(  #+++#++#XX###++++++++++++++++++++++++++++++++++++++++++++++++++++#++++#)",
      R"(   #++++++##xx####++++++++++++++++++++++++++++++++++++++####++++++##+++#)",
      R"(    #+++++++#xxxxx#####+++++++++++++++++++++++++++######XX#++++++##+++#)",
      R"(     #+++++++#xxxxxxxxx########++++++++++#########xxxxxx##++++++++++##)",
      R"(      ##++++++#xxxxxxxxxxxxxxxx##########xxxxxxxxxxxxx##+++++++++++#)",
      R"(        #++++++##xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx###+++++++++++##)",
      R"(         #+++++++#xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(          #+++++++#xxxxxxxxxxxxxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(           #+++++++##xxxxxxxxxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(            ##+++++++#xxxxxxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(              ##++++++##xxxxxxxxxxxxxxxxx##++++++++++++##)",
      R"(                ##++++++##xxxxxxxxxxxxx##++++++++++++##)",
      R"(                  ##++++++###xxxxxxx###++++++++++++##)",
      R"(                    ##+++++++#######+++++++++++++##)",
      R"(                      ##+++++++++++++++++++++++##)",
      R"(                        ##+++++++++++++++++++##)",
      R"(                          ##+++++++++++++####)",
      R"(                            #############)"
    };
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Kermit1::Width() const
    {
      return max_element(g_kermit1.begin(), g_kermit1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Kermit1::Height() const
    {
      return g_kermit1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Kermit1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        int  green;
        if (16 > COLORS) {
          green = ColorPairs::Pair("green");
        }
        else {
          green = ColorPairs::Pair("brightgreen");
        }
        wattrset(win, green|A_NORMAL);
        for (int ln = 0; ln < g_kermit1.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_kermit1[ln].c_str());
          wclrtoeol(win);
        }
        int  white = ColorPairs::Pair("white");
        int  red = ColorPairs::Pair("red");
        for (int ln = 0; ln < g_kermitmask1.size(); ++ln) {
          for (int c = 0; c < g_kermitmask1[ln].size(); ++c) {
            if ('w' == g_kermitmask1[ln][c]) {
              mvwchgat(win, origy+ln, origx+c, 1, A_NORMAL, white, nullptr);
            }
            else if ('x' == g_kermitmask1[ln][c]) {
              mvwchgat(win, origy+ln, origx+c, 1, A_NORMAL, red, nullptr);
            }
            else {
              mvwchgat(win, origy+ln, origx+c, 1, A_BOLD, green, nullptr);
            }
          }
        }
        wmove(win, origy+g_kermit1.size(), origx);
        wclrtobot(win);
      }
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
