//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/mcrover/DwmMcroverSnoopy1.cc 10997 $
// @(#) $Id: DwmMcroverSnoopy1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverSnoopy1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>

#include "DwmMcroverSnoopy1.hh"
#include "DwmMcroverColorPairs.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string>  g_snoopy1 = {
      R"(         O_      __)()",
      R"(       ,'  `.   (_".`.)",
      R"(      :      :    /|`)",
      R"(      |      |   ((|_  ,-.)",
      R"(      ; -   /:  ,'  `:(( -\)",
      R"(     /    -'  `: ____ \\\-:)",
      R"(    _\__   ____|___  \____|_)",
      R"(   ;    | |        '-`      :)",
      R"(  :_____|:|__________________:)",
      R"(  ;     |:|                  :)",
      R"( :      |:|                   :)",
      R"( ;_______`'___________________:)",
      R"(:                              :)",
      R"(|______________________________|)",
      R"( `---.--------------------.---')",
      R"(     |____________________|)",
      R"(     |                    |)",
      R"(     |____________________|)",
      R"(     |                    |)",
      R"(   _\|_\|_\/(__\__)\__\//_|(_)"
    };

        static const vector<string>  g_snoopymask1 = {
      R"(         ww      yyyy)",
      R"(       ww  ww   yyyyyy)",
      R"(      w      w    yyy)",
      R"(      w      w   yyyy  www)",
      R"(      w w   ww  ww  wwww ww)",
      R"(     w    ww  ww wwww wwwww)",
      R"(    rwww   wwwwwwww  wwwwwww)",
      R"(   r    w w        www      r)",
      R"(  rrrrrrwwwrrrrrrrrrrrrrrrrrrr)",
      R"(  r     www                  r)",
      R"( r      www                   r)",
      R"( rrrrrrrrwwrrrrrrrrrrrrrrrrrrrr)",
      R"(r                              r)",
      R"(rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr)",
      R"( rrrrrrrrrrrrrrrrrrrrrrrrrrrrrr)",
      R"(     rrrrrrrrrrrrrrrrrrrrrr)",
      R"(     r                    r)",
      R"(     rrrrrrrrrrrrrrrrrrrrrr)",
      R"(     r                    r)",
      R"(   gggggggggggggggggggggggggg)"
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Snoopy1::Width() const
    {
      return max_element(g_snoopy1.begin(), g_snoopy1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Snoopy1::Height() const
    {
      return g_snoopy1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Snoopy1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        for (int ln = 0; ln < g_snoopy1.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_snoopy1[ln].c_str());
          wclrtoeol(win);
        }
        int  yellow = ColorPairs::Pair("brightyellow");
        int  red = ColorPairs::Pair("brightred");
        int  green = ColorPairs::Pair("brightgreen");
        if (COLORS < 16) {
          yellow = ColorPairs::Pair("yellow");
          red = ColorPairs::Pair("red");
          green = ColorPairs::Pair("green");
        }
        int  white = ColorPairs::Pair("white");
        int  cp;
        for (int ln = 0; ln < g_snoopymask1.size(); ++ln) {
          for (int c = 0; c < g_snoopymask1[ln].size(); ++c) {
            if (g_snoopymask1[ln][c] != ' ') {
              switch (g_snoopymask1[ln][c]) {
                case 'g':  cp = green;    break;
                case 'r':  cp = red;      break;
                case 'w':  cp = white;    break;
                case 'y':  cp = yellow;   break;
                default:                  break;
              }
              mvwchgat(win, origy + ln, origx + c, 1, A_BOLD, cp,
                       nullptr);
            }
          }
        }
        mvwchgat(win, origy+g_snoopy1.size(), origx, -1, A_NORMAL,
                 white, nullptr);    
      }
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
