//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/mcrover/DwmMcroverTigger1.cc 10997 $
// @(#) $Id: DwmMcroverTigger1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverTigger1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>
#include <cstring>
#include <curses.h>

#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverTigger1.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string>  g_tigger1 = {
      R"(                                 _.- -.- -._     ..)",
      R"(                             .;;"  .oe$$$eeu.. ,?;UU.)",
      R"(                          ,+'!!  e$$$$$$$R$$$$x ?xd$)",
      R"(                        ,'  !~ u$$$$F,$$$by,?$"e $F"        _ -)",
      R"(              .,;,.   ,dm  :! $$$$$$d( )$( )?d$F       _ -       _)",
      R"(             !?????X!!!!~!!!X!."?????$$$F'.:::::::   -   .  - ~)",
      R"(             +$$$$$m@`!!   ~? `!kCCU$$$$ ::::::::: g~  ~ -  _)",
      R"(              "$BeCeW$:`~..__~x W$$$$$$$e `:::::'.$F           ~)",
      R"(                "****"      ,``~~?$:=$$$$$$epppe$F`)",
      R"(                        , '   ,    ?W.""??$$FFF" *.)",
      R"(                      '     .     . ?$$e. ==+* ..$f)",
      R"(                   '     . '      H8.?$$$$$$$$$$$f)",
      R"(                      . '        8888 ?$$$$$$$$$$)",
      R"(                             . ~88888? ?$$$$$$$f.)",
      R"(                         . '     8888~*..****C.-8:..)",
      R"(                  . -  ~888:.    ?88~.$$$$$$$$$$.8888:` .)",
      R"(             .- ~8::.    88888.  ?X e$$$$$$$$$$$$.`888   .8 - _)",
      R"(         . `~8?: ~88888  888888888 $$$$$$$$$$$$$$$  88   88     8?)",
      R"(        '      88:888888888888888`:$$$$$$$$$$$$$$$U ~ :8888    88~ `)",
      R"(     .:::::...  88888888~~~~8888X $$$$$$$$$$$$$$$$$  88888...:<~`   `)",
      R"(    +   ~~88888888~~     ::88888":$$$$$$$$$$$$$$$$$~ *~~8888*`     .:8)",
      R"(   ::::::::8888          "`~~88~ *""$$$$$$$$$$$$$$$~       888888888``)",
      R"(  ,"`~~888888~           :        u$$$$$$$$$$$$$$$$~       8888``"   ;)",
      R"( . .... ~888             .   ..+ $$$$$$$$$$$$$$$$$$~      .888888?:::-)",
      R"( 888888888888::::+       88~~~~~ **""$$$$$$$$$$$$$*    .+88888888(  ,)",
      R"(;888888888888888~        888::.. ue$$$$$$$$$$$$$$$~ 8888888888888888)",
      R"(88888888888``            ~888888 $$$$$$$$$$$$$$$$$     888888888888)",
      R"(88888888888             .   `~~8 $$$$$$$$$$$$$$$$`    :8888888888X`)",
      R"(~8888888888             ....::88 $$$$$$$$$$$$$$$$     8888888888~)",
      R"( `~88888888             88888888m$$$$$$$$$$$$$$$      8888888*`)",
      R"(   `*~X8~*              8888888*:$$$$$$$$$$$$$$~      ``((`)",
      R"(                      :88::   ` "?I$$$$$$$$$$$`)",
      R"(                      `~88888- e$$$$$$$$$$$$$~)",
      R"(                   '     `*~8 $$$$$$$$$$$$$$" .)",
      R"(                .:8:.     .: e$$$$$$$$$$$$$" ~  `)",
      R"(              '    `~888888~:$$$$$$$$$$$$* :*    :8       ......)",
      R"(           ::::::..   ~888` $$$$$$$$$$$$":8~  :88` `  .8888888888)",
      R"(          -~88888888::..88 8$$$$$$$$$$*.888..88~ ..- :8888888~888~)",
      R"(        '     "~~888888888 #$$$$$$$$*(888888888.+8~ :88888~`- -`8)",
      R"(      ;            `8888888."*$$**" `````"`8888888 88888~)",
      R"(                ..  .88888~~`               `8888`:888`        ')",
      R"(      `.:88888888888888~:                     8888888~       ')",
      R"(       ~8888888~~`~888888:::                  ~888888      ')",
      R"(                .:888888888888:                `88888_  ')",
      R"(              :::::::8?888888888)",
      R"(           :888888888888888888~)",
      R"(           `~8888888888888~~)"
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Tigger1::Width() const
    {
      return max_element(g_tigger1.begin(), g_tigger1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Tigger1::Height() const
    {
      return g_tigger1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Tigger1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        int  white = ColorPairs::Pair("white");
        int  brown = ColorPairs::Pair("brown");
        wattrset(win, COLOR_PAIR(ColorPairs::Pair("orange"))|A_BOLD);
        for (int ln = 0; ln < g_tigger1.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_tigger1[ln].c_str());
          wclrtoeol(win);
          for (int c = 0; c < (g_tigger1[ln].size()); ++c) {
            if (g_tigger1[ln][c] == '$') {
              mvwchgat(win, origy+ln, origx + c, 1, A_BOLD, white, nullptr);
            }
            else if ((':' == g_tigger1[ln][c]) || ('~' == g_tigger1[ln][c])) {
              mvwchgat(win, origy+ln, origx + c, 1, A_BOLD, brown, nullptr);
            }
          }
        }
        
        mvwchgat(win, origy+g_tigger1.size(), origx, -1, A_NORMAL, white,
                 nullptr);
      }
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
