//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/qmcrover/DwmMcroverPeriodForecastsWidget.cc 11932 $
// @(#) $Id: DwmMcroverPeriodForecastsWidget.cc 11932 2022-04-11 02:01:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverPeriodForecastsWidget.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <QScrollArea>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcroverPeriodForecastsWidget.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/qmcrover/DwmMcroverPeriodForecastsWidget.cc 11932 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    PeriodForecastsWidget::PeriodForecastsWidget(QWidget *parent,
                                                 Qt::WindowFlags f)
        : QWidget(parent, f), _myMinSize(1600,1200)
    {
      setSizePolicy(QSizePolicy::MinimumExpanding,
                    QSizePolicy::MinimumExpanding);
      _layout = new QVBoxLayout();
      _layout->setSizeConstraint(QLayout::SetMinimumSize);
      _layout->setContentsMargins(0,0,0,0);
      _layout->setSpacing(0);
      setLayout(_layout);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void PeriodForecastsWidget::Populate(Dwm::Mcweather::PeriodForecasts periods)
    {
      Syslog(LOG_INFO, "Received period forecasts");
      setSizePolicy(QSizePolicy::MinimumExpanding,
                    QSizePolicy::MinimumExpanding);
      
      QLayoutItem  *child;
      while ((child = _layout->takeAt(0)) != nullptr) {
        delete child->widget();
        delete child;
      }

      for (const auto & period : periods.Forecasts()) {
        // Syslog(LOG_DEBUG, "Got weather for %s", forecast.Name().c_str());
        PeriodForecastWidget  *forecastWidget = new PeriodForecastWidget();
        forecastWidget->Populate(period);
        _layout->addWidget(forecastWidget);
      }
      _layout->update();
      return;
    }

#if 0
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QSize PeriodForecastsWidget::sizeHint() const
    {
      return _myMinSize;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QSize PeriodForecastsWidget::minimumSizeHint() const
    {
      return _myMinSize;
    }
#endif
    
  }  // namespace Mcrover

}  // namespace Dwm
