//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/qmcrover/DwmMcroverWeatherImageWidget.hh 11932 $
// @(#) $Id: DwmMcroverWeatherImageWidget.hh 11932 2022-04-11 02:01:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverWeatherImageWidget.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERWEATHERIMAGEWIDGET_HH_
#define _DWMMCROVERWEATHERIMAGEWIDGET_HH_

#include <tuple>

#include <QPainter>
#include <QWidget>

#include "DwmMcweatherPeriodForecast.hh"
#include "DwmMcroverWeatherImageData.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class WeatherImageWidget
      : public QWidget
    {
    public:
      WeatherImageWidget(QWidget *parent = nullptr,
                         Qt::WindowFlags f = Qt::WindowFlags());

      QSize sizeHint() const override
      {
        return QSize(120, 120);
      }

      void Populate(const Mcweather::PeriodForecast & periodForecast);
      
    protected:
      typedef std::tuple<QImage,QPointF,double> ImgLocScaleTuple;
      
      void paintEvent(QPaintEvent *event) override;
      void DrawSun(QPainter & painter, QPointF center, double scale);
      void DrawCloud(QPainter & painter);
      void DrawCloud(QPainter & painter, QPointF center, double scale);
      void DrawDaySky(QPainter & painter);
      void DrawNightSky(QPainter & painter);
      void DrawImages(QPainter & painter,
                      const std::vector<ImgLocScaleTuple> & imgs);
      void DrawImage(QPainter & painter, const ImgLocScaleTuple & img);
      void DrawBackground(QPainter & painter, const QColor & color);

    private:
      bool                _isDaytime;
      Weather::ImageData  _imageData;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERWEATHERIMAGEWIDGET_HH_
