//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/qmcrover/DwmMcroverWeatherPageWidget.cc 10997 $
// @(#) $Id: DwmMcroverWeatherPageWidget.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverWeatherPageWidget.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <QScrollBar>
#include <QScroller>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcroverWeatherPageWidget.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/apps/qmcrover/DwmMcroverWeatherPageWidget.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    WeatherPageWidget::WeatherPageWidget(QWidget *parent, Qt::WindowFlags f)
        : QFrame(parent, f)
    {
      setStyleSheet("background: #000000;");
      _forecasts = new PeriodForecastsWidget();
      _scrollArea = new QScrollArea(this);
      _scrollArea->setWidgetResizable(true);
      _scrollArea->setWidget(_forecasts);
      // _scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
      _scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
      _scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
      _scrollArea->verticalScrollBar()->setMinimum(0);
      _scrollArea->verticalScrollBar()->setMaximum(1000);
      _scrollArea->verticalScrollBar()->setSingleStep(1);
      _scrollArea->setGeometry(0, 0, 1600, 1000);
      // scrollArea->setGeometry(0, 0, width(), height());
      
      QVBoxLayout  *layout = new QVBoxLayout();
      setLayout(layout);
      layout->addWidget(_forecasts);
      layout->setSizeConstraint(QLayout::SetMinimumSize);
      layout->setStretchFactor(_forecasts, 1);

      QScroller::grabGesture(_scrollArea->viewport(),
                             QScroller::LeftMouseButtonGesture);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    PeriodForecastsWidget *WeatherPageWidget::Forecasts()
    {
      return _forecasts;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void WeatherPageWidget::mousePressEvent(QMouseEvent *event)
    {
      _mouseVertPos = event->pos().y();
      // Syslog(LOG_DEBUG, "Got mousePressEvent at pos %d", _mouseVertPos);
      return;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void WeatherPageWidget::mouseMoveEvent(QMouseEvent *event)
    {
      if (event->buttons() & Qt::LeftButton) {
        // Syslog(LOG_DEBUG, "Got mouseMoveEvent, pos %d", event->pos().y());
        int amt = event->pos().y() - _mouseVertPos;
        QScrollBar  *sb = _scrollArea->verticalScrollBar();
        sb->setValue(sb->value() - amt);
        _mouseVertPos = event->pos().y();
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void WeatherPageWidget::pageChanged(QWidget *w)
    {
      if (dynamic_cast<QWidget *>(this->parent()) == w) {
        _scrollArea->verticalScrollBar()->setValue(0);
      }
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
