//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/classes/src/DwmMcroverHttpWorker.cc 11957 $
// @(#) $Id: DwmMcroverHttpWorker.cc 11957 2022-04-23 02:43:57Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020, 2022
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverHttpWorker.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::HttpWorker class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmWebUtils.hh"
#include "DwmMcroverHttpStatusHandler.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/classes/src/DwmMcroverHttpWorker.cc 11957 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    HttpWorker::HttpWorker(HttpStatusHandler & statusHandler)
        : _statusHandler(statusHandler)
    {
      Start();
      Syslog(LOG_DEBUG, "HttpWorker %p created", this);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    HttpWorker::~HttpWorker()
    {
      Syslog(LOG_DEBUG, "HttpWorker %p destroyed", this);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void HttpWorker::ProcessWork(HttpStatusJob & job)
    {
      Syslog(LOG_DEBUG, "Processing job %s, %s",
             ((string)(job.addr)).c_str(), job.webTarget.URI().c_str());
      job.status = WebUtils::GetStatus(job.webTarget.URI());
      _statusHandler.HandleStatus(job);
      return;
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
