//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.12/classes/tests/TestUtils.cc 10997 $
// @(#) $Id: TestUtils.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestUtils.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <iomanip>
#include <iostream>

#include "DwmIpv4Prefix.hh"
#include "DwmUnitAssert.hh"
#include "DwmMcroverUtils.hh"

using namespace std;
using Dwm::Assertions, Dwm::Ipv4Address;
using Dwm::Mcrover::LocalNetInterface, Dwm::Mcrover::Utils, Dwm::Ipv4Prefix;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestHaveLocalInterfaces()
{
  vector<LocalNetInterface>  intfs;
  UnitAssert(Utils::ThisHostInterfaces(intfs));
  UnitAssert(! intfs.empty());
  Ipv4Prefix  loopbackNet("127/8");
  for (const auto & intf : intfs) {
    if (loopbackNet.Contains(intf.Ipv4Addr())) {
      UnitAssert(intf.IsLoopback());
      UnitAssert(intf.IsUp());
      UnitAssert(intf.Ipv4Netmask() == Ipv4Address("255.0.0.0"));
      UnitAssert(intf.Ipv4Network().Contains(Ipv4Address("127.1.1.1")));
    }
    if (! loopbackNet.Contains(intf.Ipv4Addr())) {
      UnitAssert(! intf.IsLoopback());
      UnitAssert(intf.Ipv4Network().Contains(intf.Ipv4Addr()));
      UnitAssert(! intf.Ipv4Network().Contains(Ipv4Address("127.0.0.1")));
    }
  }
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestHaveArpForDefaultRoute()
{
  uint32_t  defaultRoute = Utils::ThisHostDefaultIpv4Route();
  UnitAssert(defaultRoute != INADDR_NONE);
  UnitAssert(Utils::HaveArpEntry(Ipv4Address(defaultRoute)));
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestGetArpEntries()
{
  map<Dwm::Ipv4Address,Dwm::MacAddress>  entries;
  UnitAssert(Utils::ThisHostArpEntries(entries));
  UnitAssert(! entries.empty());
  uint32_t  defaultRoute = Utils::ThisHostDefaultIpv4Route();
  if (UnitAssert(defaultRoute != INADDR_NONE)) {
    UnitAssert(entries.find(defaultRoute) != entries.end());
  }
#if 0
  for (const auto entry : entries) {
    cerr << "ARP " << setw(15) << entry.first << ' ' << entry.second << '\n';
  }
#endif
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestIpv4Routes()
{
  map<Dwm::Ipv4Prefix,Dwm::Ipv4Address>  routes;
  UnitAssert(Utils::ThisHostIpv4Routes(routes));

  uint32_t  defaultRoute = Utils::ThisHostDefaultIpv4Route();
  UnitAssert(defaultRoute != INADDR_NONE);
  Ipv4Address  gateway;
  UnitAssert(Utils::ThisHostsRouteTo(Ipv4Prefix("0/0"), gateway));
  UnitAssert(gateway == Ipv4Address(defaultRoute));
  UnitAssert(Utils::ThisHostsRouteTo(Ipv4Prefix("192.172.226.1"), gateway));
  UnitAssert(gateway == Ipv4Address(defaultRoute));
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  int  rc = 1;
  TestHaveLocalInterfaces();
  TestHaveArpForDefaultRoute();
  TestIpv4Routes();
  TestGetArpEntries();
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
    rc = 0;
  }
  return rc;
}
