//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/mchmc/mchmc.cc 10997 $
// @(#) $Id: mchmc.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file mchmc.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <iostream>
#include <sstream>

#include "DwmSocket.hh"
#include "DwmAuthPeerAuthenticator.hh"
#include "DwmMcroverAlertStore.hh"
#include "DwmMcroverUtils.hh"

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  if (argc == 2) {
    Ipv4Address  servAddr(argv[1]);
    if (servAddr.Raw() == INADDR_NONE) {
      uint32_t inAddr = Mcrover::Utils::GetHostIpv4Addr(argv[1]);
      if (inAddr == INADDR_NONE) {
        cerr << "Unknown host " << argv[1] << '\n';
        return 1;
      }
      servAddr = inAddr;
    }
    Socket  socket;
    if (socket.Open(PF_INET, SOCK_STREAM, 0)) {
      if (socket.Connect(servAddr, 2123)) {
        Auth::PeerAuthenticator  peerAuth("", "");
        string  theirId, agreedKey;
        if (peerAuth.Authenticate((int)socket, theirId, agreedKey)) {
          uint32_t  cmd = htonl(2);
          if (write((int)socket, &cmd, sizeof(cmd)) == sizeof(cmd)) {
            Auth::SymCrypto::Message  msg(agreedKey);
            if (msg.Read((int)socket) > 0) {
              istringstream  is(msg.Value());
              Mcrover::AlertStore  alertStore;
              if (alertStore.Read(is)) {
                std::vector<Mcrover::Alert>  alerts;
                alertStore.GetAllAlerts(alerts);
                for (const auto & alert : alerts) {
                  cout << alert.DisplayString() << '\n';
                }
              }
            }
          }
        }
      }
    }
  }
}
