//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/mcrover/DwmMcroverStatusWindow.cc 10997 $
// @(#) $Id: DwmMcroverStatusWindow.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverStatusWindow.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverStatusWindow.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/mcrover/DwmMcroverStatusWindow.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    StatusWindow::StatusWindow(const std::string & server)
        : _server(server)
    {
      _win = newwin(1, COLS, LINES - 1, 0);
      if (COLORS < 16) {
        wattrset(_win, COLOR_PAIR(ColorPairs::Pair("cyan"))|A_NORMAL);
      }
      else {
        wattrset(_win, COLOR_PAIR(ColorPairs::Pair("skyblue/dkgray"))|A_BOLD);
      }
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    StatusWindow::~StatusWindow()
    {
      if (_win) {
        delwin(_win);
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void StatusWindow::Update(const std::string & chosenHost, int numAlerts)
    {
      _server = chosenHost;
      std::string  s(_server);
      int          ws = COLS - _server.size();
      if (ws > 0) {
        s.append(ws, ' ');
      }
      mvwaddstr(_win, 0, 0, s.c_str());
      wrefresh(_win);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void StatusWindow::Resize()
    {
      wresize(_win, 1, COLS);
      mvwin(_win, LINES - 1, 0);
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
