//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/mcroverd/DwmMcroverDualStackSocket.cc 11323 $
// @(#) $Id: DwmMcroverDualStackSocket.cc 11323 2020-12-03 00:09:35Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverDualStackSocket.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <unistd.h>
  #include <sys/types.h>
  #include <sys/socket.h>
}

#include <cstring>

#include "DwmMcroverDualStackSocket.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    DualStackSocket::DualStackSocket(const Ipv4Address & v4Addr,
                                     uint16_t v4Port,
                                     const Ipv6Address & v6Addr,
                                     uint16_t v6Port)
        : _v4Addr(v4Addr), _v4Port(v4Port), _v6Addr(v6Addr), _v6Port(v6Port),
          _sockfd(-1), _sock6fd(-1)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool DualStackSocket::Listen()
    {
      bool  rc = false;
      if (Open()) {
        if (Bind()) {
          if (listen(_sockfd, 10)) {
            if (listen(_sock6fd, 10)) {
              rc = true;
            }
            else {
              Close();
            }
          }
          else {
            Close();
          }
        }
        else {
          Close();
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int DualStackSocket::Sock() const
    {
      return _sockfd;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int DualStackSocket::Sock6() const
    {
      return _sock6fd;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool DualStackSocket::Open()
    {
      bool  rc = false;
      _sockfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
      if (0 <= _sockfd) {
        _sock6fd = socket(PF_INET6, SOCK_STREAM, IPPROTO_TCP);
        if (0 <= _sock6fd) {
          rc = true;
        }
        else {
          close(_sockfd);
          _sockfd = -1;
        }
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool DualStackSocket::Bind()
    {
      bool  rc = false;
      struct sockaddr_in  sockAddr;
      memset(&sockAddr, 0, sizeof(sockAddr));
#ifndef __linux__
      sockAddr.sin_len = sizeof(sockAddr);
#endif
      sockAddr.sin_family = AF_INET;
      sockAddr.sin_addr.s_addr = _v4Addr.Raw();
      sockAddr.sin_port = htons(_v4Port);
      socklen_t  addrLen = sizeof(sockAddr);
      if (::bind(_sockfd, (const struct sockaddr *)&sockAddr, addrLen) == 0) {
        struct sockaddr_in6  sock6Addr;
        memset(&sock6Addr, 0, sizeof(sock6Addr));
        sock6Addr.sin6_family = AF_INET6;
        sock6Addr.sin6_port = htons(_v6Port);
        sock6Addr.sin6_addr = in6addr_any;
#ifndef __linux__
        sock6Addr.sin6_len = sizeof(sock6Addr);
#endif
        if (::bind(_sock6fd, (struct sockaddr *)&sock6Addr, sizeof(sock6Addr))
            == 0) {
          rc = true;
        }
      }
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void DualStackSocket::Close()
    {
      if (0 <= _sockfd) {
        close(_sockfd);
        _sockfd = -1;
      }
      if (0 <= _sock6fd) {
        close(_sock6fd);
        _sock6fd = -1;
      }
      return;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
