//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/mcroverd/DwmMcroverListenSocket.hh 11317 $
// @(#) $Id: DwmMcroverListenSocket.hh 11317 2020-12-02 07:06:41Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverListenSocket.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERLISTENSOCKET_HH_
#define _DWMMCROVERLISTENSOCKET_HH_

#include "DwmMcroverTCPAddress.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class ListenSocket
    {
    public:
      ListenSocket();
      ListenSocket(const ListenSocket & listenSocket) = default;
      ListenSocket & operator = (const ListenSocket &) = default;
      ListenSocket(const TCPAddress & listenAddr);
      const TCPAddress & Addr() const  { return _listenAddr; }
      bool Listen();
      int Accept(TCPAddress & clientAddr);
      void Close();
      int Descriptor() const;
      bool operator < (const ListenSocket & ls) const;
      bool operator == (const ListenSocket & ls) const;
      
    private:
      TCPAddress  _listenAddr;
      int         _fd;

      bool Open();
      void ReuseAddr();
      bool Bind();
      bool BindIpv4();
      bool BindIpv6();
    };

  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERLISTENSOCKET_HH_
