//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/qmcrover/DwmMcroverQRotatedHeaderView.cc 10997 $
// @(#) $Id: DwmMcroverQRotatedHeaderView.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverQRotatedHeaderView.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmMcroverQRotatedHeaderView.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/qmcrover/DwmMcroverQRotatedHeaderView.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QRotatedHeaderView::QRotatedHeaderView(Qt::Orientation orientation,
                                           QWidget *parent)
        : QHeaderView(orientation, parent), _margin(10), _metrics(font()),
          _descent(_metrics.descent())
    {
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void QRotatedHeaderView::paintSection(QPainter *painter,
                                          const QRect & rect,
                                          int logicalIndex) const
    {
      auto  data = getData(logicalIndex).toString();
      painter->rotate(90);
      painter->setFont(font());
      painter->drawText(-rect.height() + _margin,
                       rect.left() + (rect.width() + _descent) / 2, data);
      return;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QSize QRotatedHeaderView::sizeHint() const
    {
      return QSize(0, getTextWidth() + 2 * _margin);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QVariant QRotatedHeaderView::getData(int section) const
    {
      return model()->headerData(section, orientation());
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int QRotatedHeaderView::getTextWidth() const
    {
      int  rc = 0;
      for (int i = 0; i < model()->columnCount(); ++i) {
        int  txtWidth = _metrics.horizontalAdvance(getData(i).toString());
        if (txtWidth > rc) {
          rc = txtWidth;
        }
      }
      return rc;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
