//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/apps/tcpconntest/tcpconntest.cc 10997 $
// @(#) $Id: tcpconntest.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file tcpconntest.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#if 0
extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <sys/select.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
  #include <fcntl.h>
  #include <netdb.h>
  #include <unistd.h>
}
#endif

#include <cstring>
#include <fstream>
#include <iostream>
#include <sstream>

#include <nlohmann/json.hpp>

#include "DwmIO.hh"
#include "DwmMcroverAlertBowl.hh"
#include "DwmMcroverConfig.hh"
#include "DwmMcroverUtils.hh"
#include "DwmMcroverTcp4Utils.hh"

using namespace std;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  using Dwm::Mcrover::AlertBowl, Dwm::Mcrover::AlertOrigin,
    Dwm::Mcrover::Tcp4Utils, Dwm::Mcrover::Config;
  
  int  rc = 1;

  if (argc == 2) {
    Config  config;
    if (config.Parse(argv[1])) {
      AlertBowl  alertBowl;
      AlertOrigin  alertOrigin("mypack", Dwm::Ipv4Address("127.0.0.1"));
      if (Tcp4Utils::GetAlerts(alertOrigin, config.Servers(), alertBowl)) {
        vector<AlertBowl::EntryType>  alerts;
        alertBowl.Get(alerts);
        for (const auto & alert : alerts) {
          cout << alert.second.DisplayString() << '\n';
        }
      }
      else {
        rc = 0;
        cout << "No Tcp4Conn alerts\n";
      }
    }
    else {
      cerr << "Failed to parse config from '" << argv[1] << "'\n";
    }
  }
  else {
    cerr << "Usage: " << argv[0] << " configFile\n";
  }
  
  return rc;
}
