//===========================================================================
//  Copyright (c) Daniel W. McRobb 2022
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverWebAppWorker.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::WebAppWorker class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERWEBAPPWORKER_HH_
#define _DWMMCROVERWEBAPPWORKER_HH_

#include "DwmLoadBalancer.hh"
#include "DwmWebUtilsGetFailure.hh"
#include "DwmMcroverWebAppTarget.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    struct WebAppStatusJob
    {
      std::string           name;
      IpAddress             addr;
      WebAppTarget          webAppTarget;
      WebUtils::GetFailure  getFail;
    };

    class WebAppStatusHandler;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class WebAppWorker
      : public LoadBalancer<WebAppStatusJob>::Worker
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      WebAppWorker(WebAppStatusHandler & statusHandler);

      ~WebAppWorker();
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void ProcessWork(WebAppStatusJob & job);

    private:
      WebAppStatusHandler  &_statusHandler;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERWEBAPPWORKER_HH_
