//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverBanditUtils.cc 11049 $
// @(#) $Id: DwmMcroverBanditUtils.cc 11049 2020-08-31 03:40:46Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverBanditUtils.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::BanditUtils class implementation
//---------------------------------------------------------------------------

#include <algorithm>

#include "DwmSvnTag.hh"
#include "DwmMcroverBanditUtils.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverBanditUtils.cc 11049 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool BanditUtils::GetAlerts(const AlertOrigin & origin,
                                const LocalHostConfig & local,
                                AlertBowl & alerts,
                                bool clearAtEntry)
    {
      using std::find_if;
      
      if (clearAtEntry) {
        alerts.Clear();
      }
      Ipv4Address  localAddr(Utils::ThisHostIpv4Addr());
      std::map<Ipv4Address,MacAddress>  arpEntries;
      Utils::ThisHostArpEntries(arpEntries);
      for (const auto arpEntry : arpEntries) {
        auto  it = find_if(local.Bandits().begin(), local.Bandits().end(),
                           [&] (const auto & banditPrefix)
                           { return banditPrefix.Contains(arpEntry.first); });
        if (it != local.Bandits().end()) {
          alerts.Add(origin, BanditAlert(arpEntry.second, arpEntry.first),
                     time((time_t *)0));
        }
      }
      return (! alerts.Empty());
    }
    
  }  // namespace Mcrover

  
}  // namespace Dwm
