%{
  #include <map>
  #include <regex>

  #include "DwmIpv4Address.hh"
  #include "DwmIpv6Address.hh"
  #include "DwmSvnTag.hh"
  #include "DwmSysLogger.hh"
  #include "DwmMcroverConfig.hh"
  #include "DwmMcroverConfigParse.hh"

  extern std::string  g_configPath;
  
  extern "C" {
    #include <stdarg.h>

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void mcrovercfgerror(const char *arg, ...)
    {
      va_list  ap;
      va_start(ap, arg);
      char  *s = nullptr;
      if (vasprintf(&s, arg, ap) != -1) {
        Syslog(LOG_ERR, "%s: '%s' at line %d of %s\n",
               s, yytext, yylineno, g_configPath.c_str());
      }
      return;
    }
  }

  static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverConfigLex.lex 12187 $");

  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  static const std::map<std::string,int>  g_configKeywords = {
    { "BANDITS",             BANDITS        },
    { "CREDENCE",            CREDENCE       },
    { "DISKS",               DISKS          },
    { "DNS",                 DNS            },
    { "FS",                  FS             },
    { "GUESTS",              GUESTS         },
    { "RPC",                 RPC            },
    { "RPC6",                RPC6           },
    { "ROUTES",              ROUTES         },
    { "SMTP",                SMTP           },
    { "SMTP6",               SMTP6          },
    { "UPS",                 UPS            },
    { "WEB",                 WEB            },
    { "WEBAPP",              WEBAPP         },
    { "ZFS",                 ZFS            },
    { "ZPOOL",               ZPOOL          },
    { "addresses",           ADDRESSES      },
    { "address",             ADDRESS        },
    { "alerts",              ALERTS         },
    { "allowedClients",      ALLOWEDCLIENTS },
    { "appname",             APPNAME        },
    { "capacity",            CAPACITY       },
    { "device",              DEVICE         },
    { "facility",            FACILITY       },
    { "false",               FALSESTRING    },
    { "host",                HOST           },
    { "ipv4",                IPV4           },
    { "ipv6",                IPV6           },
    { "keyDirectory",        KEYDIRECTORY   },
    { "latitude",            LATITUDE       },
    { "level",               LEVEL          },
    { "local",               LOCAL          },
    { "location",            LOCATION       },
    { "logLocations",        LOGLOCATIONS   },
    { "longitude",           LONGITUDE      },
    { "mount",               MOUNT          },
    { "name",                NAME           },
    { "members",             MEMBERS        },
    { "otherpacks",          OTHERPACKS     },
    { "params",              PARAMS         },
    { "port",                PORT           },
    { "protocol",            PROTOCOL       },
    { "qname",               QNAME          },
    { "qtype",               QTYPE          },
    { "resolve",             RESOLVE        },
    { "servers",             SERVERS        },
    { "service",             SERVICE        },
    { "stations",            STATIONS       },
    { "store",               STORE          },
    { "status",              STATUS         },
    { "syslog",              SYSLOG         },
    { "tcp4",                TCP4           },
    { "tcp6",                TCP6           },
    { "tcp4Denied",          TCP4DENIED     },
    { "tcp6Denied",          TCP6DENIED     },
    { "true",                TRUESTRING     },
    { "pack",                PACK           },
    { "uri",                 URI            },
    { "validateCertificate", VALIDATECERT   },
    { "version",             VERSION        },
    { "weather",             WEATHER        },
    { "xpath",               XPATH          }
  };

  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  static bool IsKeyword(const std::string & s, int & token)
  {
    bool  rc = false;
    auto  it = g_configKeywords.find(s);
    if (g_configKeywords.end() != it) {
      token = it->second;
      rc = true;
    }
    return rc;
  }

  //--------------------------------------------------------------------------
  //!  
  //--------------------------------------------------------------------------
  static bool IsNumber(const std::string & s)
  {
    using std::regex, std::smatch;
    static regex  rgx("[0-9]+", regex::ECMAScript|regex::optimize);
    smatch        sm;
    return std::regex_match(s, sm, rgx);
  }

%}

%option noyywrap
%option prefix="mcrovercfg"
%option yylineno

%x x_quoted
        
%%

<INITIAL>#.*\n
<INITIAL>[^ \t\n\[\]{}=,;"]+       { if (IsNumber(yytext)) {
                                       mcrovercfglval.intVal = atoi(yytext);
                                       return INTEGER;
                                     }
                                     else {
                                       int  token;
                                       if (IsKeyword(yytext, token)) {
                                         return token;
                                       }
                                       else {
                                         mcrovercfglval.stringVal =
                                           new std::string(yytext);
                                         return STRING;
                                       }
                                     }
                                   }
<INITIAL>["]                       { BEGIN(x_quoted); }
<x_quoted>[^"]+                    { mcrovercfglval.stringVal =
                                       new std::string(yytext);
                                     return STRING; }
<x_quoted>["]                      { BEGIN(INITIAL); }
<INITIAL>[=,;\[\]\{\}]             { return yytext[0]; }
<INITIAL>[ \t\n]

%%
