//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverUPSStatus.cc 11049 $
// @(#) $Id: DwmMcroverUPSStatus.cc 11049 2020-08-31 03:40:46Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverUPSStatus.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::UPSStatus class implementation
//---------------------------------------------------------------------------

#include <map>
#include <vector>

#include "DwmSvnTag.hh"
#include "DwmMcroverUPSStatus.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverUPSStatus.cc 11049 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    UPSStatus::UPSStatus()
        : _status(e_upsUnknown)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    UPSStatus::UPSStatus(const string & status)
        : _status(e_upsUnknown)
    {
      static const vector<pair<string,StatusEnum>>  statuses = {
        { "OL", e_upsOnLinePower },
        { "OB", e_upsOnBattery   },
        { "LB", e_upsLowBattery  }
      };
      for (const auto & m : statuses) {
        if (status.rfind(m.first) != string::npos) {
          _status = m.second;
          break;
        }
      }
    }
          
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    UPSStatus::UPSStatus(StatusEnum status)
        : _status(status)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    UPSStatus::StatusEnum UPSStatus::Status() const
    {
      return _status;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    UPSStatus::StatusEnum UPSStatus::Status(UPSStatus::StatusEnum status)
    {
      _status = status;
      return _status;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string UPSStatus::StatusName() const
    {
      string  rc("Unknown");
      static const map<StatusEnum,string>  statuses = {
        { e_upsOnLinePower, "OnLinePower" },
        { e_upsOnBattery,   "OnBattery"   },
        { e_upsLowBattery,  "LowBattery"  }
      };
      auto  it = statuses.find(_status);
      if (it != statuses.end()) {
        rc = it->second;
      }
      return rc;
    }
    


  }  // namespace Mcrover

}  // namespace Dwm
