//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverUPSUtils.cc 10997 $
// @(#) $Id: DwmMcroverUPSUtils.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverUPSUtils.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::UPSUtils class implementation
//---------------------------------------------------------------------------

#include <algorithm>

#include "DwmSvnTag.hh"
#include "DwmMcroverUPSUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.1/classes/src/DwmMcroverUPSUtils.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool UPSUtils::GetAlerts(const AlertOrigin & origin,
                             const std::vector<TargetHostConfig> & hosts,
                             AlertBowl & alerts, bool clearAtEntry)
    {
      if (clearAtEntry) {
        alerts.Clear();
      }
      vector<UPSTarget>  targets;
      for (const auto & host : hosts) {
        if (! host.UPS().empty()) {
          targets.push_back(UPSTarget(host));
        }
      }
      if (! targets.empty()) {
        for (auto & target : targets) {
          map<string,UPSStatus>  results;
          target.Test(results);
          for (const auto & result : results) {
            if (UPSStatus::e_upsOnLinePower != result.second.Status()) {
              UPSAlert  alert(target.Name(), target.Address(),
                              result.first, result.second);
              alerts.Add(origin, alert, time((time_t *)0));
            }
          }
        }
      }
      return (! alerts.Empty());
    }

#if 0
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool UPSUtils::GetAlerts(map<UPSTarget, vector<Alert>> & alerts,
                             bool clearAtEntry)
    {
      for (auto & t : alerts) {
        if (clearAtEntry) {
          t.second.clear();
        }
        map<string,UPSStatus>  hostResult;
        t.first.Test(hostResult);
        for (const auto & result : hostResult) {
          if (UPSStatus::e_upsOnLinePower != result.second.Status()) {
            //  xxx: fix me, I need real probe address
            UPSAlert  alert(t.first.Name(), t.first.Address(),
                            result.first, result.second);
            t.second.push_back(Alert(time((time_t *)0), alert));
          }
        }
      }
      return any_of(alerts.begin(), alerts.end(),
                    [] (const pair<const UPSTarget, vector<Alert>> & p) 
                    { return (! p.second.empty()); });
    }
#endif
    
  }  // namespace Mcrover

}  // namespace Dwm
