dnl  ###  
dnl  ###  
dnl  ###  
define(DWM_PRESET_PATH,[
  case $1 in
    sbindir)
      if test "$[$1]" = '${exec_prefix}/sbin'; then
        $1=$2
      fi
      ;;
    datadir)
      if test "$[$1]" = '${prefix}/share'; then
        $1=$2
      fi
      ;;
    bindir)
      if test "$[$1]" = '${exec_prefix}/bin'; then
        $1=$2
      fi
      ;;
    libdir)
      if test "$[$1]" = '${exec_prefix}/lib'; then
        $1=$2
      fi
      ;;
    libexecdir)
      if test "$[$1]" = '${exec_prefix}/libexec'; then
        $1=$2
      fi
      ;;
    sysconfdir)
      if test "$[$1]" = '${prefix}/etc'; then
        $1=$2
      fi
      ;;
    sharedstatedir)
      if test "$[$1]" = '${prefix}/com'; then
        $1=$2
      fi
      ;;
    localstatedir)
      if test "$[$1]" = '${prefix}/var'; then
        $1=$2
      fi
      ;;
    infodir)
      if test "$[$1]" = '${prefix}/info'; then
        $1=$2
      fi
      ;;
    mandir)
      if test "$[$1]" = '${prefix}/man'; then
        $1=$2
      fi
      ;;
    srcdir)
      ;;
    includedir)
      if test "$[$1]" = '${prefix}/include'; then
        $1=$2
      fi
      ;;
    *)
      ;;
  esac
  if test -z "$dwm_install_max_name_len" ; then
    dwm_install_max_name_len=`echo $1 | wc -c | awk '{print [$1]}'`
  else
    if test `echo $1 | wc -c` -ge [$dwm_install_max_name_len] ; then
      dwm_install_max_name_len=`echo $1 | wc -c | awk '{print [$1]}'`
    fi
  fi
  dwm_preset_path_names="$dwm_preset_path_names $1"
  dwm_preset_path_values="$dwm_preset_path_values $[$1]"
])


dnl  #############################################################
dnl  ###  Function to add a path for an installation directory.  #
dnl  ###  We'll check/set the variable whose name is passed      #
dnl  ###  as the first argument ($1), which is also a '--with-'  #
dnl  ###  argument for configure.  The second argument should    #
dnl  ###  be the default value for the variable named by $1.     #
dnl  #############################################################
define(DWM_INSTALL_PATH,[
  $1=$2
  AC_ARG_WITH([$1],
              [  --with-$1=value set default \$$1 to value],
              [$1=$withval; /usr/bin/printf "%s set to %s\n" [$1] $withval],
	      [/usr/bin/printf "%s set to %s [(default)]\n" [$1] [$2]]
  )dnl
  AC_SUBST([$1])
  if test -z "$dwm_install_max_name_len" ; then
    dwm_install_max_name_len=`echo [$1] | wc -c | awk '{print [$1]}'`
  else
    if test `echo $[$1] | wc -c` -ge [$dwm_install_max_name_len] ; then
      dwm_install_max_name_len=`echo [$1] | wc -c | awk '{print [$1]}'`
    fi
  fi
  dwm_install_names="$dwm_install_names $1"
  dwm_install_vals="$dwm_install_vals $[$1]"
])dnl

dnl  #############################################################
define(DWM_REALPATH, [
  realpath . > /dev/null 2>&1
  if test $? -eq 0 ; then
    REALPATH=realpath
  else
    grealpath . > /dev/null 2>&1
    if test $? -eq 0 ; then
      REALPATH=grealpath
    fi
  fi
])

dnl  #############################################################
dnl  ###  Function to add a path for a prerequisite.             #
dnl  ###  The prerequisite is the variable whose name is passed  #
dnl  ###  as the first argument, which is also a '--with-'       #
dnl  ###  argument for configure.  The second argument should    #
dnl  ###  be the default value for the variable named by $1.     #
dnl  #############################################################
define(DWM_PREREQ_PATH,[
  $1=$2
  AC_ARG_WITH([$1],
    [AS_HELP_STRING([--with-$1=value],[set $1 to value ($3)])],
    [$1=$withval; /usr/bin/printf "%s set to %s\n" [$1] $withval],
    [if test -n "$withval" ; then 
       /usr/bin/printf "%s set to %s [(default)]\n" [$1] [$2]
     else
       /usr/bin/printf "%s not set\n" [$1]
     fi
    ]
  )dnl
  AC_SUBST([$1])
  if test -z "$dwm_prereq_max_name_len" ; then
    dwm_prereq_max_name_len=`echo [$1] | wc -c | awk '{print [$1]}'`
  else
    if test `echo $[$1] | wc -c` -ge [$dwm_prereq_max_name_len] ; then
      dwm_prereq_max_name_len=`echo [$1] | wc -c | awk '{print [$1]}'`
    fi
  fi
  dwm_prereq_names="$dwm_prereq_names $1"
  dwm_prereq_vals="$dwm_prereq_vals $[$1]"
])dnl

dnl  #############################################################
dnl  ###  Function to list prereq paths added with               #
dnl  ###  DWM_PREREQ_PATH.                                       #
dnl  #############################################################
define(DWM_LIST_PREREQ_PATHS,[
[
/bin/echo ""
/bin/echo "Prereq paths:"
dwm_name_index=0
for dwm_prereq_name in $dwm_prereq_names ; do
  dwm_val_index=0
  for dwm_prereq_value in $dwm_prereq_vals ; do
    if test "$dwm_name_index" = "$dwm_val_index"; then
      /usr/bin/printf "    %${dwm_prereq_max_name_len}s:  %s\n" $dwm_prereq_name $dwm_prereq_value
    fi
    dwm_val_index=`expr $dwm_val_index + 1`
  done
  dwm_name_index=`expr $dwm_name_index + 1`
done
/bin/echo ""
]
])

dnl  #############################################################
dnl  ###  Function to list the paths added with                  #
dnl  ###  DWM_INSTALL_PATH.                                      #
dnl  #############################################################
define(DWM_LIST_INSTALL_PATHS,[
/bin/echo ""
/bin/echo "Install paths: "
dwm_name_index=0
for dwm_install_name in $dwm_install_names ; do
  dwm_val_index=0
  for dwm_install_value in $dwm_install_vals ; do
    if test "$dwm_name_index" = "$dwm_val_index"; then
      /usr/bin/printf "    %${dwm_install_max_name_len}s:  %s\n" $dwm_install_name $dwm_install_value
    fi
    dwm_val_index=`expr $dwm_val_index + 1`
  done
  dwm_name_index=`expr $dwm_name_index + 1`
done
dwm_name_index=0
for dwm_install_name in $dwm_preset_path_names ; do
  dwm_val_index=0
  for dwm_install_value in $dwm_preset_path_values ; do
    if test "$dwm_name_index" = "$dwm_val_index"; then
      /usr/bin/printf "    %${dwm_install_max_name_len}s:  %s\n" $dwm_install_name $dwm_install_value
    fi
    dwm_val_index=`expr $dwm_val_index + 1`
  done
  dwm_name_index=`expr $dwm_name_index + 1`
done

/bin/echo ""
])

dnl ########################################################################
dnl  ###  Cheesy function to set TAGFULL, TAGNAME and TAGVERSION.
dnl  ###  [$1] is expected to contain an RCS 'Name:' tag (with the dollar
dnl  ###  signs).  If substitution has taken place for 'Name:' (via 
dnl  ###  'cvs export -r foo' or the like), we pull the value
dnl  ###  out of the tag string and set the variablesd.  If no 
dnl  ###  substitution has been performed for the 'Name:' tag, the [$2]
dnl  ###  value will be used.
dnl ########################################################################
define(DWM_SET_VERSION,[
  TAGFULL=`echo '[$1]' | sed 's/\$Name\:[[ ]]*//1' | sed 's/[[ $]]//g'`
  if test "$TAGFULL" = "" ; then
    TAGFULL=$2
  fi
  TAGNAME=`echo $TAGFULL | cut -d'-' -f1`
  TAGVERSION=`echo $TAGFULL | cut -d'-' -f2- | tr '[-]' '[.]'`
  AC_SUBST(TAGFULL)
  AC_SUBST(TAGNAME)
  AC_SUBST(TAGVERSION)
])

define(DWM_SET_PKGVARS,[
  AC_MSG_CHECKING([package variables])
  EPM_ARCH=""
  PKG_SUBDIR=[staging]
  TAGFULL=`./getvers.sh`
  if test "$TAGFULL" = "" ; then
    TAGFULL=$2
  fi
  TAGNAME=`echo $TAGFULL | cut -d'-' -f1`
  TAGVERSION=`echo $TAGFULL | cut -d'-' -f2-`
  TARDIR_RELATIVE=${PKG_SUBDIR}
  TAR_UPDATE_FLAGS="-Ppuvf"
  case $host_os in
    darwin*)
      OSNAME="darwin"
      ;;
    freebsd*)
      OSNAME="freebsd"
      OSVERSION=`uname -r | cut -d- -f1`
      OSARCH=`uname -m`
      case $OSARCH in
	i[[3456]]86)
	  OSARCH=intel
	  ;;
	*)
	  ;;
      esac
      TAR="/usr/bin/tar"
      ;;
    linux*)
      OSNAME="linux"
      OSVERSION=`uname -r | cut -d- -f1`
      OSARCH=`uname -m`
      case $OSARCH in
	i[[3456]]86)
	  OSARCH=intel
	  ;;
	*)
	  ;;
      esac
      TAR="/bin/tar"
      unamem=`uname -m`
      case ${unamem} in
        armv7l)
          EPM_ARCH="-a armhf"
          ;;
        x86_64)
          EPM_ARCH="-a amd64"
          ;;
      esac
      ;;
    solaris*)
      OSNAME="solaris"
      OSVERSION=`uname -r`
      OSARCH=`uname -p`
      case $OSVERSION in
	5.*)
	  OSVERSION=`echo $OSVERSION | sed 's/5/2/1'`
	  ;;
	*)
	  ;;
      esac
      TAR="/usr/bin/tar"
      TAR_UPDATE_FLAGS="-puvf"
      ;;
    *)
      ;;
  esac
  TARDIR=`pwd`/`dirname $[0]`/${TARDIR_RELATIVE}
  AC_SUBST(EPM_ARCH)
  AC_SUBST(OSNAME)
  AC_SUBST(OSVERSION)
  AC_SUBST(OSARCH)
  AC_SUBST(TAGFULL)
  AC_SUBST(TAGNAME)
  AC_SUBST(TAGVERSION)
  AC_SUBST(PKG_SUBDIR)
  AC_SUBST(TAR)
  AC_SUBST(TARDIR)
  AC_SUBST(TARDIR_RELATIVE)
  AC_SUBST(TAR_UPDATE_FLAGS)
  AC_MSG_RESULT([
    OSNAME="${OSNAME}"
    OSVERSION="${OSVERSION}"
    OSARCH="${OSARCH}"
    TAGFULL="${TAGFULL}"
    TAGNAME="${TAGNAME}"
    TAGVERSION="${TAGVERSION}"
    PKG_SUBDIR="${PKG_SUBDIR}"
    TAR="${TAR}"
    TARDIR="${TARDIR}"
    TARDIR_RELATIVE="${TARDIR_RELATIVE}"
    TAR_UPDATE_FLAGS="${TAR_UPDATE_FLAGS}"])
])

dnl #------------------------------------------------------------------------
dnl #  Sets flags needed for compiling omniORB files (output from omniidl)
dnl #------------------------------------------------------------------------
define(DWM_SET_OMNIFLAGS,[
  AC_MSG_CHECKING([omniORB flags])
  case $host_os in
    freebsd[[45]]*)
      AC_DEFINE(__freebsd__)
      OMNIFLAGS="-D__freebsd__"
      case $host_cpu in
        i?86)
          AC_DEFINE(__x86__)
          OMNIFLAGS="${OMNIFLAGS} -D__x86__"
          ;;
        *)
          echo "unknown host_cpu $host_cpu"
          ;;
        esac
      ;;
    linux*)
      AC_DEFINE(__linux__)
      OMNIFLAGS="-D__linux__"
      case $host_cpu in
        i?86)
          AC_DEFINE(__x86__)
          OMNIFLAGS="${OMNIFLAGS} -D__x86__"
          ;;
        *)
          echo "unknown host_cpu $host_cpu"
          ;;
      esac
      ;;
    solaris*)
      AC_DEFINE(__sunos__)
      AC_DEFINE(__OSVERSION__,5)
      OMNIFLAGS="-D__sunos__ -D__OSVERSION__=5"
      case $host_cpu in
        sparc)
          AC_DEFINE(__sparc__)
          OMNIFLAGS="${OMNIFLAGS} -D__sparc__"
          ;;
        *)
          echo "unknown host_cpu $host_cpu"
          ;;
      esac
      ;;
    *)
      ;;
  esac

  AC_SUBST(OMNIFLAGS)
  AC_MSG_RESULT([
    OMNIFLAGS=\"${OMNIFLAGS}\"])
])

dnl #------------------------------------------------------------------------
dnl #  Sets flags needed for building shared library
dnl #------------------------------------------------------------------------
define(DWM_SET_CXX_SHARED_FLAGS,[
  AC_MSG_CHECKING([cxx shared flags])
  CXX_SHARED_FLAGS=""
  LD_SHARED_FLAGS=""
  SHARED_LIB_EXT=".so"
  case $host_os in
    freebsd[[9]]*)
      CXX_SHARED_FLAGS="-fPIC"
      LD_SHARED_FLAGS="-shared"
      ;;
    freebsd1[[01]]*)
      CXX_SHARED_FLAGS="-fPIC"
      LD_SHARED_FLAGS="-shared"
      ;;
    darwin*)
      CXX_SHARED_FLAGS="-fPIC"
      LD_SHARED_FLAGS="-dynamiclib"
      SHARED_LIB_EXT=".dylib"
      ;;
    *)
      ;;
  esac

  AC_SUBST(CXX_SHARED_FLAGS)
  AC_SUBST(LD_SHARED_FLAGS)
  AC_SUBST(SHARED_LIB_EXT)
  AC_MSG_RESULT([done])
])

dnl #------------------------------------------------------------------------
dnl #  Sets flags needed for pthreads and threadsafe STL
dnl #------------------------------------------------------------------------
define(DWM_SET_PTHREADFLAGS,[
  AC_MSG_CHECKING([pthread flags])
  PTHREADCXXFLAGS=""
  PTHREADLDFLAGS=""
  PTHREADS_STL="-D_PTHREADS"
  case $host_os in
    freebsd1[[01]]*)
      AC_DEFINE(_THREAD_SAFE)
      AC_DEFINE(_PTHREADS)
      PTHREADS_OS="-pthread -D_THREAD_SAFE"
      PTHREADCXXFLAGS="${PTHREADS_OS} ${PTHREADS_STL}"
      PTHREADLDFLAGS="-pthread"
      ;;
    linux*)
      AC_DEFINE(_REENTRANT)
      AC_DEFINE(_PTHREADS)
      PTHREADS_OS="-pthread -D_REENTRANT"
      PTHREADCXXFLAGS="${PTHREADS_OS} ${PTHREADS_STL}"
      PTHREADLDFLAGS="-pthread"
      ;;
    solaris*)
      AC_DEFINE(_REENTRANT)
      AC_DEFINE(_PTHREADS)
      AC_DEFINE(_POSIX_PTHREAD_SEMANTICS)
      PTHREADS_OS="-D_REENTRANT -D_POSIX_PTHREAD_SEMANTICS"
      PTHREADCXXFLAGS="${PTHREADS_OS} ${PTHREADS_STL}"
      PTHREADLDFLAGS="-lpthread -lposix4"
      ;;
    *)
      ;;
  esac

  AC_SUBST(PTHREADS_OS)
  AC_SUBST(PTHREADS_STL)
  AC_SUBST(PTHREADCXXFLAGS)
  AC_SUBST(PTHREADLDFLAGS)
  AC_MSG_RESULT([
    PTHREADCXXFLAGS="${PTHREADCXXFLAGS}"
    PTHREADLDFLAGS="${PTHREADLDFLAGS}"])
])

define(DWM_CHECK_GETHOSTBYNAME_R,[
  AC_MSG_CHECKING([for gethostbyname_r])
  OLDCPPFLAGS="$CPPFLAGS"
  CPPFLAGS="$OLDCPPFLAGS -D_REENTRANT"
  AC_TRY_COMPILE([
      #include <sys/types.h>
      #include <sys/socket.h>
      #include <netinet/in.h>
      #include <arpa/inet.h>
      #include <netdb.h>],
    [
      struct hostent  *hp;
      struct hostent   result;
      char            *name = "caimis.com";
      char             buf[4096];

      hp = gethostbyname_r(name,&result,buf,4096,NULL);
    ],
    [AC_DEFINE(HAVE_GETHOSTBYNAME_R)
      AC_MSG_RESULT(yes)],
    [AC_MSG_RESULT(no)]
  )
  AC_SUBST(HAVE_GETHOSTBYNAME_R)
  CPPFLAGS="$OLDCPPFLAGS"
  ]
)

define(DWM_CHECK_GETHOSTBYADDR_R,[
  AC_MSG_CHECKING([for gethostbyaddr_r])
  OLDCPPFLAGS="$CPPFLAGS"
  CPPFLAGS="$OLDCPPFLAGS -D_REENTRANT"
  AC_TRY_COMPILE([
      #include <sys/types.h>
      #include <sys/socket.h>
      #include <netinet/in.h>
      #include <arpa/inet.h>
      #include <netdb.h>],
    [
      struct hostent  *hp;
      struct hostent   result;
      unsigned int     ipAddr = inet_addr("127.0.0.1");
      char             buf[4096];
	
      hp = gethostbyaddr_r(&ipAddr,sizeof(ipAddr),AF_INET,&result,
			   buf,4096,NULL);
    ],
    [AC_DEFINE(HAVE_GETHOSTBYADDR_R)
      AC_MSG_RESULT(yes)],
    [AC_MSG_RESULT(no)]
  )
  AC_SUBST(HAVE_GETHOSTBYADDR_R)
  CPPFLAGS="$OLDCPPFLAGS"
  ]
)


dnl ######################################################################
dnl #  Sets variable named [$1] to the value of the installation prefix
dnl #  for the package named by [$1].  Substitutes for [$1] in output.
dnl #  Example: DWM_FIND_PKG_PREFIX(libCaimis) would set libCaimis
dnl #  to the installation prefix (directory) where libCaimis is 
dnl #  installed, and substitute the value for all instances of 
dnl #  @libCaimis@ in output files.
dnl ######################################################################
define(DWM_FIND_PKG_PREFIX,[
  AC_MSG_CHECKING([$1 installation prefix])
  case $host_os in
    freebsd*)
      [$1]=`pkg info -p [$1\*] | head -1 | awk '{print $[2]}'`
      ;;
    linux*)
      [$1]=`rpm -q --queryformat '%{INSTALLPREFIX}' [$1]`
      ;;
    solaris*)
      [$1]=`pkginfo -r [$1]`
      ;;
    *)
      ;;
  esac

  AC_ARG_WITH([$1],
    [  --with-$1=value   set $1 to value ([$1 prefix])],
    [$1=$withval]
  )
  AC_SUBST([$1])
  AC_MSG_RESULT($[$1])

  ]
)

dnl ------------------------------------------------------------------------
dnl //  Check for <tuple> (indicating C++0x features) or <tr1/tuple>
dnl //  (indicating C++0x features in the tr1 namespace).  These were sort
dnl //  of ugly days; we now have C++11 and I use it.
dnl ------------------------------------------------------------------------
define(DWM_CHECK_CPLUSPLUS_0x,[
  AC_MSG_CHECKING([for C++0x])
  AC_LANG_PUSH(C++)
  case ${CXX} in
    clang*)
  	prev_CPPFLAGS="$CXXFLAGS"
	CXXFLAGS="$CXXFLAGS -std=c++11"
	AC_MSG_CHECKING([for C++0x features])
	AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[#include <tuple>]], [[std::tuple<int,int> t;]])],[AC_MSG_RESULT(yes)
		        AC_DEFINE(HAVE_CPP0X)],[AC_MSG_RESULT(no)
	                AC_MSG_CHECKING([for C++ TR1 features])
	        	CXXFLAGS="$prev_CPPFLAGS"
	        	_au_m4_changequote([,])AC_TRY_COMPILE([#include <tr1/tuple>],
			       	       [std::tr1::tuple<int,int> t;],
			       	       [AC_MSG_RESULT(yes)
			                AC_DEFINE(HAVE_TR1)],
			       	       [AC_MSG_RESULT(no)])])
	;;
    *)  	
	prev_CPPFLAGS="$CXXFLAGS"
	CXXFLAGS="$CXXFLAGS -std=gnu++0x"
	AC_MSG_CHECKING([for C++0x features])
	AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[#include <tuple>]], [[std::tuple<int,int> t;]])],[AC_MSG_RESULT(yes)
	                AC_DEFINE(HAVE_CPP0X)],[AC_MSG_RESULT(no)
	                AC_MSG_CHECKING([for C++ TR1 features])
	        	CXXFLAGS="$prev_CPPFLAGS"
	        	_au_m4_changequote([,])AC_TRY_COMPILE([#include <tr1/tuple>],
			               [std::tr1::tuple<int,int> t;],
			       	       [AC_MSG_RESULT(yes)
			                AC_DEFINE(HAVE_TR1)],
			       	       [AC_MSG_RESULT(no)])])
    ;;
  esac
AC_LANG_POP()
])

dnl ########################################################################
dnl #  Macro to check for the existence of C++11.  Note that this depends
dnl #  on the existence of a '-std=c++11' command line option of the C++
dnl #  compiler.  Should work for both g++ and clang++.
dnl ########################################################################
define(DWM_CHECK_CPLUSPLUS_11,[
  AC_MSG_CHECKING([for C++11])
  AC_LANG_PUSH(C++)
  prev_CPPFLAGS="$CXXFLAGS"
  CXXFLAGS="$CXXFLAGS -std=c++11"
  AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
    #include <iostream>
    #include <vector>]], [[std::vector<int> vi = { 1, 2, 3, 4 };
     for (auto i : vi) { std::cout << i << '\n'; }]])],[AC_MSG_RESULT(yes)
     AC_DEFINE(HAVE_CPP11)],[AC_MSG_RESULT(no)
     echo C++11 is required\!\!
     exit 1])
  AC_LANG_POP()
])

dnl #-------------------------------------------------------------------------
define(DWM_CHECK_CPLUSPLUS_1Z,[
  AC_MSG_CHECKING([for C++1z])
  AC_LANG_PUSH(C++)
  prev_CPPFLAGS="$CXXFLAGS"
  CXXFLAGS="$CXXFLAGS -std=c++1z"
  AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
    #include <shared_mutex>
    #include <vector>]], [[std::shared_mutex  mtx;
     std::shared_lock<std::shared_mutex>  lock(mtx);]])],[AC_MSG_RESULT(yes)
     AC_DEFINE(HAVE_CPP1Z)],[AC_MSG_RESULT(no)
     CXXFLAGS="$prev_CPPFLAGS"
     DWM_CHECK_CPLUSPLUS_11])
  AC_LANG_POP()
])

dnl #-------------------------------------------------------------------------
define(DWM_CHECK_CPLUSPLUS_17,[
  AC_MSG_CHECKING([for C++17])
  AC_LANG_PUSH(C++)
  prev_CPPFLAGS="$CXXFLAGS"
  CXXFLAGS="$CXXFLAGS -std=c++17"
  AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
    #include <shared_mutex>
    #include <vector>]], [[std::shared_mutex  mtx;
     std::shared_lock<std::shared_mutex>  lock(mtx);]])],[AC_MSG_RESULT(yes)
     AC_DEFINE(HAVE_CPP17)
     AC_DEFINE(HAVE_CPP11)
     LDFLAGS="$LDFLAGS -std=c++17"],[AC_MSG_RESULT(no)
     CXXFLAGS="$prev_CPPFLAGS"
     DWM_CHECK_CPLUSPLUS_1Z()])
  AC_LANG_POP()
])

dnl #-------------------------------------------------------------------------
define(DWM_CHECK_CPLUSPLUS_20,[
  AC_MSG_CHECKING([for C++20])
  AC_LANG_PUSH(C++)
  AX_CHECK_COMPILE_FLAG([-std=c++20], [
    AC_DEFINE(HAVE_CPP20)
    AC_DEFINE(HAVE_CPP17)
    AC_DEFINE(HAVE_CPP11)
    CXXFLAGS="$CXXFLAGS -std=c++20"
    LDFLAGS="$LDFLAGS -std=c++20"
  ], [
    DWM_CHECK_CPLUSPLUS_17()
  ])
  AC_LANG_POP()
])

dnl #-------------------------------------------------------------------------
define(DWM_CHECK_CPLUSPLUS_23,[
  AC_MSG_CHECKING([for C++23])
  AC_LANG_PUSH(C++)
  AX_CHECK_COMPILE_FLAG([-std=c++23], [
    AC_DEFINE(HAVE_CPP23)
    CXXFLAGS="$CXXFLAGS -std=c++23"
    LDFLAGS="$LDFLAGS -std=c++23"
  ], [
    DWM_CHECK_CPLUSPLUS_20()
  ])
  AC_LANG_POP()
])

dnl #------------------------------------------------------------------------
define(DWM_FIND_INSTALLED_CRYPTOPP,[
  AC_MSG_CHECKING([for Crypto++])
  case $host_os in
    linux*)
      guess=`dpkg -L cryptopp | grep lib/libcryptopp | awk -F '/lib' '{print $[1]}'`
      if [[ $? -eq 0 ]]; then
        cryptoppdir=[$guess]
      fi
      ;;
    freebsd*)
      guess=`pkg info --prefix cryptopp | awk '{print $[2]}'`
      if [[ $? -eq 0 ]]; then
        cryptoppdir=[$guess]
      fi
      ;;
    darwin*)
      if [[ -d /usr/local/include/cryptopp ]]; then
        cryptoppdir=/usr/local
      else
        if [[ -d /opt/local/include/cryptopp ]]; then
	  cryptoppdir=/opt/local
	fi
      fi
      ;;
  esac
  if [[ -n "${cryptoppdir}" ]]; then
    AC_LANG_PUSH(C++)
    prev_CPPFLAGS="$CXXFLAGS"
    CXXFLAGS="$CXXFLAGS -I${cryptoppdir}/include"
    AC_TRY_COMPILE([
      #include <cryptopp/rng.h>
      #include <cryptopp/osrng.h>],
      [CryptoPP::AutoSeededRandomPool  rng;],
      [AC_MSG_RESULT(${cryptoppdir})
       AC_DEFINE(HAVE_CRYPTOPP)
       CRYPTOPPDIR=[${cryptoppdir}]
       AC_SUBST(CRYPTOPPDIR)],
      [AC_MSG_RESULT(no)
       echo Crypto++ is required\!\!
       exit 1])
    CXXFLAGS="$prev_CPPFLAGS"
    AC_LANG_POP()
  else
    AC_MSG_RESULT(not found)
    echo Crypto++ is required\!\!
    exit 1
  fi
])

dnl #------------------------------------------------------------------------
define(DWM_FIND_INSTALLED_BOOST_IOSTREAMS,[
  AC_MSG_CHECKING([for boost iostreams])
  case $host_os in
    linux*)
      guess=`dpkg -L boost 2>/dev/null | grep lib/libboost_iostreams | head -1 | awk -F '/lib' '{print $[1]}'`
      if [[ $? -eq 0 -a -n "$guess" ]]; then
        boostdir=[$guess]
      else
        guess=`dpkg -L libboost-iostreams-dev 2>/dev/null | grep libboost_iostreams | head -1`
	if [[ $? -eq 0 -a -n "$guess" ]]; then
	  boostdir=[$guess]
	else
	  boost_iostream_pkg_name=`dpkg-query -W | grep ^libboost-iostreams | cut -d':' -f1`
	  guess=`dpkg -L [${boost_iostream_pkg_name}] | grep libboost_iostreams | head -1`
	  if [[ $? -eq 0 -a -n "$guess" ]]; then
	    guess2=`echo [$guess] | grep '^/usr/lib/' | cut -d'/' -f1,2`
	    if [[ $? -eq 0 -a -n "$guess2" ]]; then
	      boostdir=[$guess2]
	    fi
	  fi
	fi
      fi
      ;;
    freebsd*)
      guess=`pkg info --prefix boost-libs | awk '{print $[2]}'`
      if [[ $? -eq 0 ]]; then
        boostdir=[$guess]
      fi
      ;;
    darwin*)
      if [[ -d /opt/local/include/boost ]]; then
        boostdir=/opt/local
      else
        if [[ -d /opt/local/libexec/boost/1.81 ]]; then
	  boostdir=/opt/local/libexec/boost/1.81
	fi
      fi
      ;;
  esac
  BOOSTLIBTAG=""
  if [[ -n "${boostdir}" ]]; then
    AC_LANG_PUSH(C++)
    prev_CPPFLAGS="$CXXFLAGS"
    CXXFLAGS="$CXXFLAGS -I${boostdir}[/include]"
    AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
        #include <boost/iostreams/device/file_descriptor.hpp>]],
      [[boost::iostreams::file_descriptor_source
        fds(1, boost::iostreams::never_close_handle);]])],
      [AC_MSG_RESULT(${boostdir})
	   AC_DEFINE(HAVE_BOOST)
           BOOSTDIR=[${boostdir}]
           AC_SUBST(BOOSTDIR)],
      [AC_MSG_RESULT(no)
      echo boost iostreams is required\!\!                                     
      exit 1]
    )
    CXXFLAGS="$prev_CPPFLAGS"
    AC_LANG_POP()
  else
    AC_MSG_RESULT(not found)
    echo boost iostreams is required\!\!
    exit 1
  fi
  if [[ -f ${boostdir}/lib/libboost_iostreams-mt.dylib ]]; then
    BOOSTLIBTAG="-mt"
  fi
  AC_SUBST(BOOSTLIBTAG)
])

dnl #------------------------------------------------------------------------
define(DWM_FIND_INSTALLED_NLOHMANN_JSON,[
  AC_MSG_CHECKING([for nlohmann/json])
  case $host_os in
    linux*)
      guess=`dpkg -L nlohmannjson 2>/dev/null | grep nlohmann/json.hpp | head -1 | awk -F '/include' '{print $[1]}'`
      if [[ $? -eq 0 -a -n "$guess" ]]; then
        nlohmanndir=[$guess]
      else
        guess=`dpkg -L nlohmann-json3-dev | grep nlohmann/json.hpp | head -1 | awk -F '/include' '{print $[1]}'`
	if [[ $? -eq 0 ]]; then
          nlohmanndir=[$guess]
	fi
      fi
      ;;
    freebsd*)
      guess=`pkg info --prefix nlohmann-json | awk '{print $[2]}'`
      if [[ $? -eq 0 ]]; then
        nlohmanndir=[$guess]
      fi
      ;;
    darwin*)
      if [[ -d /usr/local/include/nlohmann ]]; then
        nlohmanndir=/usr/local
      else
        if [[ -d /opt/local/include/nlohmann ]]; then
          nlohmanndir=/opt/local
	fi
      fi
      ;;
  esac
  if [[ -n "${nlohmanndir}" ]]; then
    AC_LANG_PUSH(C++)
    prev_CPPFLAGS="$CXXFLAGS"
    CXXFLAGS="$CXXFLAGS -I${nlohmanndir}[/include]"
    AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[#include <nlohmann/json.hpp>]],
      [[nlohmann::json  j;]]
      )],
      [AC_MSG_RESULT(${nlohmanndir})
       AC_DEFINE(HAVE_NLOHMANN_JSON)
       NLOHMANNJSONDIR=[${nlohmanndir}]
       AC_SUBST(NLOHMANNJSONDIR)],
      [AC_MSG_RESULT(no)
       echo nlohmann/json is required\!\!
       exit 1])
    CXXFLAGS="$prev_CPPFLAGS"
    AC_LANG_POP()
  else
    AC_MSG_RESULT(not found)
    echo nlohmann/json is required\!\!
    exit 1
  fi
])

dnl #------------------------------------------------------------------------
define(DWM_COMPILE_BOOSTASIO,[
  AC_LANG_PUSH(C++)
  prev_CPPFLAGS="$CXXFLAGS"
  if [[ -n "$1" ]]; then
    CXXFLAGS="$CXXFLAGS -I[$1]/include"
  fi
  AC_COMPILE_IFELSE(
    [AC_LANG_PROGRAM(
      [[#include <boost/asio.hpp>]],
      [[boost::asio::ip::tcp::iostream  tcpStream;]])
    ],
    [BOOSTDIR="$1"],
    [BOOSTDIR="none"
     CXXFLAGS="$prev_CPPFLAGS"]
  )
  AC_LANG_POP()
])

dnl #------------------------------------------------------------------------
define(DWM_CHECK_BOOSTASIO,[
  AC_MSG_CHECKING([for Boost asio])
  for boost_dir in "" "/usr/local" "/opt/local" "/opt/local/libexec/boost/1.81"; do
    DWM_COMPILE_BOOSTASIO([${boost_dir}])
    if [[ "${BOOSTDIR}" != "none" ]]; then
      break
    fi
  done
  if [[ "${BOOSTDIR}" != "none" ]]; then
    AC_MSG_RESULT([found ${BOOSTDIR}])
    AC_DEFINE(HAVE_BOOSTASIO)
    if [[ -n "${BOOSTDIR}" ]]; then
      BOOSTINC=-I${BOOSTDIR}/include
      BOOSTLIBS="-L${BOOSTDIR}/lib"
    fi
    if [[ -f ${BOOSTDIR}/lib/libboost_system-mt.dylib ]]; then
      BOOSTLIBS="${BOOSTLIBS} -lboost_iostreams-mt -lboost_system-mt"
      BOOSTLIBTAG="-mt"
    else
      BOOSTLIBS="${BOOSTLIBS} -lboost_iostreams -lboost_system"
    fi
    AC_SUBST(BOOSTDIR)
    AC_SUBST(BOOSTINC)
    AC_SUBST(BOOSTLIBS)
    AC_SUBST(BOOSTLIBTAG)
  else
    echo Boost asio is required\!\!
    exit 1
  fi
])

dnl #------------------------------------------------------------------------
define(DWM_CHECK_LIB_TRIVIAL_CPLUSPLUS,[
  AC_LANG_PUSH(C++)
  prev_CPPFLAGS="$CXXFLAGS"
  prev_LIBS="$LIBS"
  CXXFLAGS="$CXXFLAGS -std=c++17"
  LIBS="${LIBS} [$1]"
  AC_MSG_CHECKING([for [$1]])
  AC_TRY_LINK([$2],[$3],
              [AC_MSG_RESULT(yes)
               AC_SUBST(LDFLAGS,[${LIBS}])],
              [AC_MSG_RESULT(no)
               LIBS="$prev_LIBS"])
  CXXFLAGS="$prev_CPPFLAGS"
  AC_LANG_POP()
])

dnl #------------------------------------------------------------------------
define(DWM_CHECK_LIBSTDCPPFS,[
  AC_MSG_CHECKING([for libstdc++fs])
  AC_LANG_PUSH(C++)
  prev_CPPFLAGS="$CXXFLAGS"
  prev_LIBS="${LIBS}"
  CXXFLAGS="$CXXFLAGS -std=c++17"
  LIBS="${LIBS} -lstdc++fs"
  AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <filesystem>]], [[std::filesystem::remove("foo");]])],[AC_MSG_RESULT(yes)
               AC_SUBST(LIBSTDCPPFS,[-lstdc++fs])],[AC_MSG_RESULT(no)
               LIBS="$prev_LIBS"])
  CXXFLAGS="$prev_CPPFLAGS"
  AC_LANG_POP()
])

dnl #------------------------------------------------------------------------
define(DWM_CHECK_LIBCPPFS,[
  DWM_CHECK_LIB_TRIVIAL_CPLUSPLUS([-lc++fs],[#include <filesystem>],
                                  [std::filesystem::remove("foo");])
])

dnl #------------------------------------------------------------------------
define(DWM_CHECK_LIBTIRPC,[
  AC_MSG_CHECKING([for libtirpc])
  AC_LANG_PUSH(C++)
  prev_CXXFLAGS="$CXXFLAGS"
  libtirpcCxxFlags=`pkg-config --cflags libtirpc 2>/dev/null`
  CXXFLAGS="${CXXFLAGS} ${libtirpcCxxFlags}"
  AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
    #include <netconfig.h>]]. [[
      setnetconfig();]])],
    [AC_MSG_RESULT(found)
     TIRPCINCS="${libtirpcCxxFlags}"
     TIRPCLIBS=`pkg-config --libs-only-l libtirpc`],
    [AC_MSG_RESULT(not found)
     CXXFLAGS="${prev_CXXFLAGS}"]
  )
  CXXFLAGS="$prev_CPPFLAGS"
  AC_LANG_POP()
  AC_SUBST(TIRPCINCS)
  AC_SUBST(TIRPCLIBS)
])
