//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/mcrover/DwmMcroverAlfred1.cc 10997 $
// @(#) $Id: DwmMcroverAlfred1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverAlfred1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>

#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverAlfred1.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string>  g_alfred1 = {
      R"(                                     .M)",
      R"(                                .:AMMO:)",
      R"(                       .:AMMMMMHIIIHMMM.)",
      R"(             ....   .AMMMMMMMMMMMHHHMHHMMMML:AMF")",
      R"(           .:MMMMMLAMMMMMMMHMMMMMMHHIHHIIIHMMMML.)",
      R"(                "WMMMMMMMMMMMMMMMMMMH:::::HMMMMMMHII:.)",
      R"(           .AMMMMMMMHHHMMMMMMMMMMHHHHHMMMMMMMMMAMMMHHHHL.)",
      R"(         .MMMMMMMMMMHHMMMMMMMMHHHHMMMMMMMMMMMMMHTWMHHHHHML)",
      R"(        .MMMMMMMMMMMMMMMMMMMHHHHHHHHHMHMMHHHHIII:::HMHHHHMM.)",
      R"(        .MMMMMMMMMMMMMMMMMMMMMMHHHHHHMHHHHHHIIIIIIIIHMHHHHHM.)",
      R"(        MMMMMMMMMMMMMMMMMHHMMHHHHHIIIHHH::IIHHII:::::IHHHHHHHL)",
      R"(        "MMMMMMMMMMMMMMMMHIIIHMMMMHHIIHHLI::IIHHHHIIIHHHHHHHHML)",
      R"(         .MMMMMMMMMMMMMM"WMMMHHHMMMMMMMMMMMLHHHMMMMMMHHHHHHHHHHH)",
      R"(        .MMMMMMMMMMMWWMW   ""YYHMMMMMMMMMMMMF""HMMMMMMMMMHHHHHHHH.)",
      R"(       .MMMMMMMMMM W" V                         W"WMMMMMHHHHHHHHHH)",
      R"(      "MMMMMMMMMM".                                 "WHHHMH"HHHHHHL)",
      R"(      MMMMMMMMMMF  .                                         IHHHHH.)",
      R"(      MMMMMMMMMM .                                  .        HHHHHHH)",
      R"(      MMMMMMMMMF. .                               .  .       HHHHHHH.)",
      R"(      MMMMMMMMM .     ,AWMMMMML.              ..    .  .     HHHHHHH.)",
      R"(    :MMMMMMMMM".  .  F"'    'WM:.         ,::HMMA, .  .      HHHHMMM)",
      R"(    :MMMMMMMMF.  . ."         WH..      AMM"'     "  .  .    HHHMMMM)",
      R"(     MMMMMMMM . .     ,;AAAHHWL"..     .:'                   HHHHHHH)",
      R"(     MMMMMMM:. . .   -MK"OTO L :I..    ...:HMA-.             "HHHHHH)",
      R"(,:IIIILTMMMMI::.      L,,,,.  ::I..    .. K"OTO"ML           'HHHHHH)",
      R"(LHT::LIIIIMMI::. .      '""'.IHH:..    .. :.,,,,           '  HMMMH:HLI')",
      R"(ILTT::"IIITMII::.  .         .IIII.     . '""""             ' MMMFT:::.)",
      R"(HML:::WMIINMHI:::.. .          .:I.     .   . .  .        '  .M"'.....I.)",
      R"("HWHINWI:.'.HHII::..          .HHI     .II.    .  .      . . :M.',, ..I:)",
      R"( "MLI"ML': :HHII::...        MMHHL     :::::  . :..      .'.'.'HHTML.II:)",
      R"(  "MMLIHHWL:IHHII::....:I:" :MHHWHI:...:W,,"  '':::.      ..'  ":.HH:II:)",
      R"(    "MMMHITIIHHH:::::IWF"    """T99"'  '""    '.':II:..'.'..'  I'.HHIHI')",
      R"(      YMMHII:IHHHH:::IT..     . .   ...  . .    ''THHI::.'.' .;H.""."H")",
      R"(        HHII:MHHI"::IWWL     . .     .    .  .     HH"HHHIIHHH":HWWM")",
      R"(         """ MMHI::HY""ML,          ...     . ..  :"  :HIIIIIILTMH")",
      R"(              MMHI:.'    'HL,,,,,,,,..,,,......,:" . ''::HH "HWW)",
      R"(              'MMH:..   . 'MMML,: """MM""""MMM"      .'.IH'"MH")",
      R"(               "MMHL..   .. "MMMMMML,MM,HMMMF    .   .IHM")",
      R"(                 "MMHHL    .. "MMMMMMMMMMMM"  . .  '.IHF')",
      R"(                   'MMMML    .. "MMMMMMMM"  .     .'HMF)",
      R"(                    HHHMML.                    .'MMF")",
      R"(                   IHHHHHMML.               .'HMF")",
      R"(                   HHHHHHITMML.           .'IF..)",
      R"(                   "HHHHHHIITML,.       ..:F...)",
      R"(                    'HHHHHHHHHMMWWWWWW::"......)",
      R"(                      HHHHHHHMMMMMMF"'........)",
      R"(                       HHHHHHHHHH............)",
      R"(                         HHHHHHHH...........)",
      R"(                          HHHHIII..........)",
      R"(                           HHIII..........)",
      R"(                            HII.........)",
      R"(                             "H........)",
      R"(                               ......)"
    };
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Alfred1::Width() const
    {
      return max_element(g_alfred1.begin(), g_alfred1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Alfred1::Height() const
    {
      return g_alfred1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Alfred1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [ypos, xpos] = Position(win);
        wattrset(win, COLOR_PAIR(ColorPairs::Pair("white"))|A_BOLD);
        for (int ln = 0; ln < g_alfred1.size(); ++ln) {
          mvwaddstr(win, ypos + ln, xpos, g_alfred1[ln].c_str());
          wclrtoeol(win);
        }
      }
      
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
