//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/mcrover/DwmMcroverColorPairs.cc 10997 $
// @(#) $Id: DwmMcroverColorPairs.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverColorPairs.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <curses.h>

#include "DwmMcroverColorPairs.hh"

namespace Dwm {

  namespace Mcrover {

    std::mutex                           ColorPairs::_mtx;
    std::unordered_map<std::string,int>  ColorPairs::_pairs;

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int ColorPairs::Pair(const std::string & name)
    {
      {
        std::lock_guard<std::mutex>  lock(_mtx);
        if (_pairs.empty()) {
          //  First, do the built-ins.  Note that even a lowly cons25 can
          //  have 64 color pairs (8 colors x 8 colors).  But we almost
          //  always want a color on a black background, so let's just
          //  define pairs for a built-in color atop a black background.
          init_pair(0, COLOR_WHITE, COLOR_BLACK);  _pairs["white"]        = 0;
          init_pair(1, COLOR_RED,   COLOR_BLACK);  _pairs["red"]          = 1;
          init_pair(2, COLOR_GREEN, COLOR_BLACK);  _pairs["green"]        = 2;
          init_pair(3, COLOR_YELLOW,COLOR_BLACK);  _pairs["yellow"]       = 3;
          init_pair(4, COLOR_BLUE,  COLOR_BLACK);  _pairs["blue"]         = 4;
          init_pair(5, COLOR_MAGENTA, COLOR_BLACK); _pairs["magenta" ]    = 5;
          init_pair(6, COLOR_CYAN,  COLOR_BLACK);  _pairs["cyan"]         = 6;
          
          init_pair(7,  8,   COLOR_BLACK);  _pairs["brightblack"]   = 7;
          init_pair(8,  9,   COLOR_BLACK);  _pairs["brightred"]     = 8;
          init_pair(9,  10,  COLOR_BLACK);  _pairs["brightgreen"]   = 9;
          init_pair(10, 11,  COLOR_BLACK);  _pairs["brightyellow"]  = 10;
          init_pair(11, 12,  COLOR_BLACK);  _pairs["brightblue"]    = 11;
          init_pair(12, 13,  COLOR_BLACK);  _pairs["brightmagenta"] = 12;
          init_pair(13, 15,  COLOR_BLACK);  _pairs["brightwhite"]   = 13;

          init_pair(33, 177, COLOR_BLACK);  _pairs["violet"]          = 33;
          init_pair(34, 191, COLOR_BLACK);  _pairs["yellowgreen"]     = 34;
          init_pair(35, 117, COLOR_BLACK);  _pairs["skyblue"]         = 35;
          init_pair(36, COLOR_YELLOW, COLOR_BLUE);  _pairs["yellow/blue"] = 36;
          init_pair(37,  82, COLOR_BLACK);  _pairs["neongreen"]       = 37;
          init_pair(38, 223, COLOR_BLACK);  _pairs["wheat1"]          = 38;
          init_pair(39, 130, COLOR_BLACK);  _pairs["brown"]           = 39;
          init_pair(40, 100, COLOR_BLACK);  _pairs["olive"]           = 40;
          init_pair(41, 172, COLOR_BLACK);  _pairs["orange"]          = 41;
          init_pair(42, 117, 235);          _pairs["skyblue/dkgray"]  = 42;
          init_pair(43,  11, 18);           _pairs["btyellow/blue"]   = 43;
        }
      }
      
      int  rc = 0;
      auto it = _pairs.find(name);
      if (it != _pairs.end()) {
        rc = it->second;
      }
      return rc;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
