//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/mcrover/DwmMcroverCows1.cc 10997 $
// @(#) $Id: DwmMcroverCows1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverCows1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>

#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverCows1.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string>  g_cows1 = {
      R"(*        (__)              (__)               (__)               (__))",
      R"( \       (oo)              (oo)               (oo)               (oo))",
      R"(  \-------\/        /-------\/         /-------\/         /-------\/)",
      R"(  /|      |\       / /      \         / \      /         / \      \)",
      R"( //||----||\\     * //------\\       *   \\--//         *   \\----\\)",
      R"( ^ ^^    ^^ ^       ^        ^            ^  ^               ^     ^)",
      R"(Cow walking         Cow jogging         Same cow         Cow braking)",
      R"( )",
      R"(          (__))",
      R"(          (oo)      )",
      R"(           \/                        (__) o       *     (__))",
      R"(       ____| \____                   (oo)/ "      |     (oo))",
      R"(       ---/   --**            /-------\/(__ o=o=o=|------\/)",
      R"(    *____/    |___//         / |       /          |      |)",
      R"(        //--------/         *  ||----||           ||----||)",
      R"(       //__                    ^^    ^^           ^^    ^^)",
      R"(       Cow marching         Cow standing         Cow pooing)"
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Cows1::Width() const
    {
      return max_element(g_cows1.begin(), g_cows1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Cows1::Height() const
    {
      return g_cows1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Cows1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        int  wheat1 = ColorPairs::Pair("wheat1");
        int  white = ColorPairs::Pair("white");
        wattrset(win, COLOR_PAIR(white)|A_BOLD);
        for (int ln = 0; ln < g_cows1.size(); ++ln) {
          if ((ln == 6) || (ln == 16)) {
            wattrset(win, COLOR_PAIR(wheat1)|A_BOLD);
          }
          else {
            wattrset(win, COLOR_PAIR(white)|A_BOLD);
          }
          mvwaddstr(win, origy + ln, origx, g_cows1[ln].c_str());
          wclrtoeol(win);
        }
      }
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
