//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/mcrover/DwmMcroverDwm1.cc 10997 $
// @(#) $Id: DwmMcroverDwm1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverSnoopyLucy1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>

#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverDwm1.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string>  g_dwm1 = {
      R"(             .dDd.)",
      R"(             DdddD)",
      R"(             DdddD)",
      R"(             DdddD)",
      R"(             DdddD)",
      R"(             DdddD)",
      R"(             DdddD)",
      R"(             DdddD)",
      R"(             DdddD)",
      R"(     ,+dDDd+.DdddD  .wWw.   .wWw.   .wWw.    ,mmmmm+, ,+mmmmm,  )",
      R"(  ,ddddddddddddddD  WwwwW   WwwwW   WwwwW   Mmmmmmmmm+mmmmmmmmM )",
      R"( ddddddddddddddddD  WwwwW   WwwwW   WwwwW  MmmmmmmmmmmmmmmmmmmmM)",
      R"(ddddd+'    `+ddddD  WwwwW   WwwwW   WwwwW  Mmmmm' 'mmmmm' 'mmmmM)",
      R"(DdddD        DdddD  WwwwW   WwwwW   WwwwW  MmmmM   MmmmM   MmmmM)",
      R"(DdddD        DdddD  WwwwW   WwwwW   WwwwW  MmmmM   MmmmM   MmmmM)",
      R"(ddddd*.    .*DdddD  WwwwW. .WwwwW. .wwwwW  MmmmM   MmmmM   MmmmM)",
      R"(`DdddddDDDddddddD'  WwwwwwWwwwwwwwWwwwwwW  MmmmM   MmmmM   MmmmM)",
      R"(  "DddddddddddD"     Wwwwwwwww+wwwwwwwwW   MmmmM   MmmmM   MmmmM)",
      R"(    `+DddddD+'        `wwwww+' '+wwwww'    "MMM"   "MMM"   "MMM")"
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Dwm1::Width() const
    {
      return max_element(g_dwm1.begin(), g_dwm1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Dwm1::Height() const
    {
      return g_dwm1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Dwm1::Draw(WINDOW *win) const
    {
      vector<int>  dwmColors = {
        ColorPairs::Pair("white"),
        ColorPairs::Pair("cyan"),
        ColorPairs::Pair("green"),
        ColorPairs::Pair("red"),
        ColorPairs::Pair("yellow"),
        ColorPairs::Pair("magenta"),
        ColorPairs::Pair("blue")
      };

      if (COLORS > 8) {
        dwmColors.push_back(ColorPairs::Pair("violet"));
        dwmColors.push_back(ColorPairs::Pair("yellowgreen"));
        dwmColors.push_back(ColorPairs::Pair("skyblue"));
        dwmColors.push_back(ColorPairs::Pair("brightred"));
        dwmColors.push_back(ColorPairs::Pair("brightyellow"));
        dwmColors.push_back(ColorPairs::Pair("olive"));
        dwmColors.push_back(ColorPairs::Pair("orange"));
      }
        
      if (win) {
        wattrset(win, COLOR_PAIR(ColorPairs::Pair("orange")|A_BOLD));
        auto [origy, origx] = Position(win);
        int  cp = 0;
        for (int ln = 0; ln < g_dwm1.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_dwm1[ln].c_str());
          for (int c = 0; c < g_dwm1[ln].size(); ++c) {
            if (g_dwm1[ln][c] != ' ') {
              mvwchgat(win, origy + ln, origx + c, 1, A_BOLD,
                       dwmColors[cp % dwmColors.size()],
                       nullptr);
              ++cp;
            }
          }
        }
        wclrtoeol(win);
      }
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
