//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/mcrover/DwmMcroverSnoopyLucy1.cc 10997 $
// @(#) $Id: DwmMcroverSnoopyLucy1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverSnoopyLucy1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>

#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverSnoopyLucy1.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string>  g_snoopyLucy = {
      R"(                  _  .-.)",
      R"(                 ( `'  |)",
      R"(                  `.  /)",
      R"(                    |/)",
      R"(                    ')",
      R"(                _    \ .        |)",
      R"(               (_ |\/| L\ /` |/ |)",
      R"(               __)|  | | \\_,|\ ')",
      R"(             ,.--.)",
      R"(           ,/     `\     \)",
      R"(     _,-""-|        |     ')",
      R"(   ,'       ;`-.,.-'       ')",
      R"(  /          \   \       ,-.)",
      R"( ;           | /  `._.-. \_.r-"'-.    _.._)",
      R"( ;        .-./   /|     )/        `''`    `'.)",
      R"( |       /       `     -'7         \         \  '.)",
      R"( ;       |_,           | \          `       ,|    \)",
      R"(  \         `.      ___/  \               /;;.\    ;)",
      R"(   \          |  .'` .'    `-._         /;;;;;||)",
      R"(f`'-'         /  _.-'          `'.      ||;;;;;|)",
      R"( \          .'|_\.-. .-.          `\   f\';;;'/  |)",
      R"(  `-.___,.'``'-.| /_._/_            \__| `'-'` .')",
      R"(        /           _\'.)           '---')",
      R"(.   |   \     _.-'.__7 /`.   _     /     `.)",
      R"(|   `.   `'-' |     _.'   t'` )   ;    |   \)",
      R"(\           _ | _.-'   _,'  .'    |    ;  |;;)",
      R"( `.       // '7;_,..-'` _,-`      ;    '  \ ;| .-._)",
      R"(          `'-/'     __.-\_\        \    \ \`);f_,.-`)",
      R"(            '--''"`` \.-'\ >"--._   `-|. `-`/)",
      R"(       ____________.-f._.;"'--. _).--'__ | \)",
      R"(   '''""""''''    (___<7/_______)(/_/`r `   `"-.mx___)",
      R"(    Schulz                          `'------'--`  --)"
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int SnoopyLucy1::Width() const
    {
      return max_element(g_snoopyLucy.begin(), g_snoopyLucy.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int SnoopyLucy1::Height() const
    {
      return g_snoopyLucy.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void SnoopyLucy1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        for (int ln = 0; ln < g_snoopyLucy.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_snoopyLucy[ln].c_str());
          wclrtoeol(win);
        }
      }
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
