//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/mcroverd/DwmMcroverDualStackSocket.hh 11311 $
// @(#) $Id: DwmMcroverDualStackSocket.hh 11311 2020-12-01 05:55:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverDualStackSocket.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERDUALSTACKSOCKET_HH_
#define _DWMMCROVERDUALSTACKSOCKET_HH_

#include "DwmIpv4Address.hh"
#include "DwmIpv6Address.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class DualStackSocket
    {
    public:
      DualStackSocket(const Ipv4Address & v4Addr = INADDR_ANY,
                      uint16_t v4Port = 2123,
                      const Ipv6Address & v6Addr = Ipv6Address(in6addr_any),
                      uint16_t v6Port = 2123);
      bool Listen();
      int Sock() const;
      int Sock6() const;
      
    private:
      Ipv4Address  _v4Addr;
      uint16_t     _v4Port;
      Ipv6Address  _v6Addr;
      uint16_t     _v6Port;
      int          _sockfd;
      int          _sock6fd;

      bool Open();
      bool Bind();
      void Close();
    };

  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERDUALSTACKSOCKET_HH_
