//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/qmcrover/DwmMcroverAlertItemDelegate.cc 10997 $
// @(#) $Id: DwmMcroverAlertItemDelegate.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverAlertItemDelegate.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <regex>
#include <QTextDocument>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcroverAlertItemDelegate.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/qmcrover/DwmMcroverAlertItemDelegate.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static std::string GetDecoratedString(QString & str)
    {
      std::string  origstr(str.toStdString());
      std::string  rc;
      static const std::regex
        rgx("([0-9][0-9][/][0-9][0-9] [0-9][0-9][:][0-9][0-9] )([^ ]+ )([^ ]+ )(.+)",
            std::regex::ECMAScript|std::regex::optimize);
      std::smatch  sm;
      if (std::regex_match(origstr, sm, rgx)) {
        if (sm.size() == 5) {
          rc = "<span style=\"color: #00cdcd; font-size: 36px;\">";
          rc += sm[1].str() + "</span>";
          rc += "<span style=\"color: #d787ff; font-size: 36px;\">";
          rc += sm[2].str() + "</span>";
          rc += "<span style=\"color: #ffffff; font-size: 36px;\">";
          rc += sm[3].str() + "</span>";
          rc += "<span style=\"color: #00ff00; font-size: 36px;\">";
          rc += sm[4].str() + "</span>";
        }
      }
      if (rc.empty()) {
        rc = "<span style=\"color: #ffffff; font-size: 36px;\">";
        rc += origstr + "</span>";
      }
      return rc;
    }
    

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void AlertItemDelegate::paint(QPainter *painter,
                                  const QStyleOptionViewItem & option,
                                  const QModelIndex & index) const
    {
      // return QStyledItemDelegate::paint(painter, option, index);
      
      QStyleOptionViewItem  options = option;
      options.font.setPixelSize(36);
      initStyleOption(&options, index);

      std::string  htmlStr = GetDecoratedString(options.text);
      painter->save();
      
      QTextDocument  doc;
      doc.setDefaultFont(options.font);
      doc.setDocumentMargin(0);
      doc.setHtml(htmlStr.c_str());
      
      painter->translate(options.rect.left(), options.rect.top());
      QRect clip(0, 0, options.rect.width(), options.rect.height() * 4);
      doc.drawContents(painter, clip);
      
      painter->restore();

      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QSize AlertItemDelegate::sizeHint(const QStyleOptionViewItem & option,
                                      const QModelIndex & index) const
    {
      QStyleOptionViewItem   options = option;
      options.font.setPixelSize(36);
      initStyleOption(&options, index);
      
      std::string  htmlStr = GetDecoratedString(options.text);

      QTextDocument doc;
      doc.setDefaultFont(options.font);
      // doc.setDocumentMargin(0);
      doc.setHtml(htmlStr.c_str());
      // doc.setTextWidth(options.rect.width());
      return QSize(doc.idealWidth(), 40 /* * doc.size().height() */);
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
