//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/qmcrover/DwmMcroverCurrentWeatherWidget.cc 11932 $
// @(#) $Id: DwmMcroverCurrentWeatherWidget.cc 11932 2022-04-11 02:01:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverCurrentWeatherWidget.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <climits>
#include <iomanip>
#include <sstream>
#include <QVBoxLayout>

#include "DwmDateTime.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverCurrentWeatherWidget.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/qmcrover/DwmMcroverCurrentWeatherWidget.cc 11932 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    CurrentWeatherWidget::CurrentWeatherWidget(QWidget *parent,
                                               Qt::WindowFlags f)
        : QFrame(parent, f)
    {
      setSizePolicy(QSizePolicy::MinimumExpanding,
                    QSizePolicy::Fixed);
                      
      QVBoxLayout  *layout = new QVBoxLayout();
      layout->setAlignment(Qt::AlignHCenter|Qt::AlignTop);
      layout->setSpacing(0);

      _stationLabel = new QLabel("----");
      _stationLabel->setStyleSheet("color: #ffff80;");
      QFont  font = _stationLabel->font();
      font.setPointSize(28);
      QFont  bigFont = font;
      bigFont.setPointSize(72);

      font.setUnderline(true);
      _stationLabel->setFont(font);
      font.setUnderline(false);

      _temperatureLabel = new QLabel("----");
      _temperatureLabel->setStyleSheet("color: #ffffff;");
      _temperatureLabel->setFont(bigFont);
      _humidityLabel = new QLabel("----");
      _humidityLabel->setStyleSheet("color: #ff87af;");
      _humidityLabel->setFont(font);
      _pressureLabel = new QLabel("----");
      _pressureLabel->setFont(font);
      _dewpointLabel = new QLabel("----");
      _dewpointLabel->setStyleSheet("color: #00ffff;");
      _dewpointLabel->setFont(font);
      _windSpeedLabel = new QLabel("----");
      _windSpeedLabel->setStyleSheet("color: #00ff00;");
      _windSpeedLabel->setFont(font);
      _windChillOrHeatIndexLabel = new QLabel("----");
      _windChillOrHeatIndexLabel->setFont(font);

      layout->addWidget(_stationLabel);
      layout->setAlignment(_stationLabel, Qt::AlignHCenter);
      layout->addWidget(_temperatureLabel);
      layout->setAlignment(_temperatureLabel, Qt::AlignHCenter);
      layout->addWidget(_humidityLabel);
      layout->setAlignment(_humidityLabel, Qt::AlignHCenter);
      layout->addWidget(_pressureLabel);
      layout->setAlignment(_pressureLabel, Qt::AlignHCenter);
      layout->addWidget(_dewpointLabel);
      layout->setAlignment(_dewpointLabel, Qt::AlignHCenter);
      layout->addWidget(_windSpeedLabel);
      layout->setAlignment(_windSpeedLabel, Qt::AlignHCenter);
      layout->addWidget(_windChillOrHeatIndexLabel);
      layout->setAlignment(_windChillOrHeatIndexLabel, Qt::AlignHCenter);
      setLayout(layout);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QSize CurrentWeatherWidget::sizeHint() const
    {
      return QSize(241, 330);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void CurrentWeatherWidget::Populate(Mcweather::CurrentConditions wcc)
    {
      _stationLabel->setText(wcc.Station().c_str());
      const QChar degreeChar(0260);
      _temperatureLabel->setText(QString("%1%2").arg(wcc.Temperature()).arg(degreeChar));
      _humidityLabel->setText(QString("%1 %2%").arg("Hum").arg(wcc.RelativeHumidity()));
      std::ostringstream  pos;
      pos << std::setprecision(4)
          << wcc.BarometricPressure() * 0.0002952998751;
      // double inhg = wcc.BarometricPressure() * 0.0002952998751;
      _pressureLabel->setText(QString("%1 in. Hg").arg(pos.str().c_str()));
      _dewpointLabel->setText(QString("Dew %1%2").arg(wcc.Dewpoint()).arg(degreeChar));
      if (INT_MAX != wcc.WindSpeed()) {
        _windSpeedLabel->setText(QString("%1 mph").arg(wcc.WindSpeed()));
      }
      else {
        _windSpeedLabel->setText(QString("-- mph"));
      }
      if (INT_MAX != wcc.WindChill()) {
        _windChillOrHeatIndexLabel->setText(QString("Chill %1%2").arg(wcc.WindChill()).arg(degreeChar));
      }
      else if (INT_MAX != wcc.HeatIndex()) {
        _windChillOrHeatIndexLabel->setText(QString("Heat %1%2").arg(wcc.HeatIndex()).arg(degreeChar));
      }
      else {
        _windChillOrHeatIndexLabel->setText("");
      }
      return;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    CurrentWeatherWidgetPair::CurrentWeatherWidgetPair(QWidget *parent,
                                                       Qt::WindowFlags f)
        : QFrame(parent, f)
    {
      QVBoxLayout  *layout = new QVBoxLayout();
      layout->setAlignment(Qt::AlignHCenter|Qt::AlignTop);
      layout->setSpacing(0);
      layout->setContentsMargins(0, 5, 0, 5);
      
      _first = new CurrentWeatherWidget();
      layout->addWidget(_first);
      layout->setAlignment(_first, Qt::AlignHCenter);

      _second = new CurrentWeatherWidget();
      layout->addWidget(_second);
      layout->setAlignment(_second, Qt::AlignHCenter);

      setLayout(layout);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void
    CurrentWeatherWidgetPair::Populate(int sn,
                                       Mcweather::CurrentConditions wcc)
    {
      switch (sn) {
        case 0:
          _first->Populate(wcc);
          break;
        case 1:
          _second->Populate(wcc);
          break;
        default:
          break;
      }
      return;
    }

  }  // namespace Mcrover

  
}  // namespace Dwm
