//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/qmcrover/DwmMcroverRadarView.cc 11538 $
// @(#) $Id: DwmMcroverRadarView.cc 11538 2020-12-18 00:46:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverRadarView.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmMcroverRadarView.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/qmcrover/DwmMcroverRadarView.cc 11538 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RadarView::RadarView(QWidget *parent)
        : QGraphicsView(parent), _scene(this)
    {
      setRenderHints(QPainter::Antialiasing | QPainter::TextAntialiasing);
      setScene(&_scene);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void RadarView::Populate(QString radarFile, float latitude,
                             float longitude)
    {
      ClearScene();
      QImage  qimg(radarFile);
      if (! qimg.isNull()) {
        //  We want a 1600x1000 image, cropped from the original 3400x1600.
        //  127.5 is roughly the westmost point in the original image.
        //  50.45 is roughly the northmost point in the original image.
        //  55.6 is roughly the number of pixels per degree in the original
        //  image.
        const int    desiredWidth = 1600, desiredHeight = 1000;
        const float  westMostDeg  = 127.5;
        const float  northMostDeg = 50.45;
        const float  pixelsPerDeg = 55.6;
        int  x = ((westMostDeg - (-longitude)) * pixelsPerDeg);
        x -= (desiredWidth / 2);
        if (x > (3400 - desiredWidth)) {
          x = 3400 - desiredWidth;
        }
        else if (x < 0) {
          x = 0;
        }
        int  y = ((northMostDeg - latitude) * pixelsPerDeg);
        y -= (desiredHeight / 2);
        if (y > (1600 - desiredHeight)) {
          y = 1600 - desiredHeight;
        }
        else if (y < 0) {
          y = 0;
        }
        QImage  croppedImg = qimg.copy(x, y, desiredWidth, desiredHeight);
        _pxmInScene = _scene.addPixmap(QPixmap::fromImage(croppedImg));
        _scene.setSceneRect(croppedImg.rect());
        fitInView(_pxmInScene, Qt::KeepAspectRatio);
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void RadarView::ClearScene()
    {
      QList<QGraphicsItem *>  sceneItems = _scene.items();
      for (auto item : sceneItems) {
        _scene.removeItem(item);
        delete item;
      }
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
