//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/qmcrover/DwmMcroverStackedWidget.cc 11942 $
// @(#) $Id: DwmMcroverStackedWidget.cc 11942 2022-04-17 04:05:11Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverStackedWidget.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::StackedWidget class implementation
//---------------------------------------------------------------------------

#include <algorithm>
#include <deque>
#include <iostream>

#include "DwmMcroverStackedWidget.hh"
#include "DwmMcroverUserActivityTracker.hh"
#include "DwmMcroverNWSRadarPageWidget.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    StackedWidget::StackedWidget(QWidget *parent)
        : QStackedWidget(parent)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void StackedWidget::nextPage()
    {
      auto  ci = currentIndex() + 1;
      if (ci >= count()) {
        ci = 0;
      }
      setCurrentIndex(ci);
      emit pageChanged(widget(ci));
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void StackedWidget::prevPage()
    {
      auto  ci = currentIndex();
      if (ci == 0) {
        ci = count() - 1;
      }
      else {
        --ci;
      }
      setCurrentIndex(ci);
      emit pageChanged(widget(ci));
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void StackedWidget::pageByName(QString pageName)
    {
      QWidget  *c = findChild<QWidget *>(pageName);
      if (c) {
        auto  idx = indexOf(c);
        if ((idx != -1) && (idx != currentIndex())) {
          setCurrentIndex(idx);
          emit pageChanged(c);
        }
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void StackedWidget::newAlerts(std::shared_ptr<std::vector<AlertBowl::EntryType>> alerts) 
    {
      if (! alerts->empty()) {
        QWidget  *pw = parentWidget();
        if (pw) {
          pw->setStyleSheet("background-color: #400000;");
        }
        if (UserInactive(30)) {
          pageByName("alertPage");
        }
      }
      return;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void StackedWidget::noAlerts()
    {
      static  std::deque<std::string>  noAlertPages = {
        "weatherPage", "nwsRadarPage"
      };
      
      if (UserInactive(30)) {
        pageByName(noAlertPages.front().c_str());
        std::rotate(noAlertPages.begin(), noAlertPages.begin() + 1,
                    noAlertPages.end());
      }
      QWidget  *pw = parentWidget();
      if (pw) {
        pw->setStyleSheet("background-color: #000000;");
      }
      return;
    }

  }  // namespace Mcrover

}  // namespace Dwm
