//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/apps/qmcrover/DwmMcroverWeatherFetcher.hh 11974 $
// @(#) $Id: DwmMcroverWeatherFetcher.hh 11974 2022-04-24 16:33:33Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020, 2022
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverWeatherFetcher.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::WeatherFetcher class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERWEATHERFETCHER_HH_
#define _DWMMCROVERWEATHERFETCHER_HH_

#include <ctime>
#include <mutex>
#include <condition_variable>
#include <thread>

#include <QObject>

#include <nlohmann/json.hpp>

#include "DwmCredencePeer.hh"
#include "DwmMcweatherCurrentConditions.hh"
#include "DwmMcweatherPeriodForecasts.hh"
#include "DwmMcroverConfig.hh"

Q_DECLARE_METATYPE(Dwm::Mcweather::PeriodForecasts);
Q_DECLARE_METATYPE(Dwm::Mcweather::CurrentConditions);

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  Encapsulates a thread to fetch weather information from mcweatherd.
    //------------------------------------------------------------------------
    class WeatherFetcher
      : public QObject
    {
      Q_OBJECT

    public:
      WeatherFetcher(const Config & config);
      ~WeatherFetcher();
      bool Start();
      bool Stop();
      
    signals:
      void newForecasts(Mcweather::PeriodForecasts forecasts);
      void currentConditions(int sn, Mcweather::CurrentConditions cc);
      
    private:
      Config                   _config;
      bool                     _run;
      std::mutex               _runmtx;
      std::condition_variable  _runcv;
      std::thread              _thread;
      time_t                   _lastFetchedForecast;
      
      bool GetForecasts(Credence::Peer & peer);
      bool GetCurrentConditions(Credence::Peer & peer);
      void Run();
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERWEATHERFETCHER_HH_
