//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverAlertBase.hh 11163 $
// @(#) $Id: DwmMcroverAlertBase.hh 11163 2020-09-08 07:45:15Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverAlertBase.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::AlertBase class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERALERTBASE_HH_
#define _DWMMCROVERALERTBASE_HH_

#include <string>

#include <nlohmann/json.hpp>

#include "DwmDescriptorIOCapable.hh"
#include "DwmFileIOCapable.hh"
#include "DwmStreamIOCapable.hh"
#include "DwmStreamedLengthCapable.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  Base class for all alerts.
    //------------------------------------------------------------------------
    class AlertBase
      : public Dwm::DescriptorIOCapable, public Dwm::FileIOCapable,
        public Dwm::StreamIOCapable, public Dwm::StreamedLengthCapable
    {
    public:
      //----------------------------------------------------------------------
      //!  Returns the alert priority.  By default, return 0xFF (255).
      //----------------------------------------------------------------------
      virtual uint8_t Priority() const;
      
      //----------------------------------------------------------------------
      //!  Returns a JSON representation of the alert.
      //----------------------------------------------------------------------
      virtual nlohmann::json ToJson() const = 0;
      
      //----------------------------------------------------------------------
      //!  Populates the alert from a JSON representation @c j.  Returns
      //!  true on success, faluse on failure.
      //----------------------------------------------------------------------
      virtual bool FromJson(const nlohmann::json & j) = 0;
      
      //----------------------------------------------------------------------
      //!  Returns a string representation of the alert that is used by
      //!  display clients (mcrover, qmcrover et. al.).
      //----------------------------------------------------------------------
      virtual std::string DisplayString() const = 0;

    protected:
      //----------------------------------------------------------------------
      //!  At the moment I don't want anyone to delete an instance of a
      //!  derived class through a pointer or reference to this class.
      //----------------------------------------------------------------------
      ~AlertBase()  { }
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERALERTBASE_HH_
